/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.command;

import com.artformgames.plugin.residencelist.lib.easyplugin.command.NamedExecutor;
import com.artformgames.plugin.residencelist.lib.easyplugin.command.SubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandHandler
implements TabExecutor,
NamedExecutor {
    @NotNull
    protected final JavaPlugin plugin;
    @NotNull
    protected final String cmd;
    @NotNull
    protected final List<String> aliases;
    @NotNull
    protected final Map<String, SubCommand<?>> registeredCommands = new HashMap();
    @NotNull
    protected final Map<String, CommandHandler> registeredHandlers = new HashMap<String, CommandHandler>();
    @NotNull
    protected final Map<String, String> aliasesMap = new HashMap<String, String>();

    public CommandHandler(@NotNull JavaPlugin plugin) {
        this(plugin, plugin.getName());
    }

    public CommandHandler(@NotNull JavaPlugin plugin, @NotNull String cmd) {
        this(plugin, cmd, new String[0]);
    }

    public CommandHandler(@NotNull JavaPlugin plugin, @NotNull String cmd, String ... aliases) {
        this.plugin = plugin;
        this.cmd = cmd;
        this.aliases = Arrays.asList(aliases);
    }

    public abstract Void noArgs(CommandSender var1);

    public Void unknownCommand(CommandSender sender, String[] args) {
        return this.noArgs(sender);
    }

    public abstract Void noPermission(CommandSender var1);

    public Void onException(CommandSender sender, SubCommand<?> cmd, Exception ex) {
        sender.sendMessage("Error occurred when executing " + cmd.getIdentifier() + ": " + ex.getLocalizedMessage());
        ex.printStackTrace();
        return null;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.cmd;
    }

    public void registerSubCommand(SubCommand<?> command) {
        String name = command.getIdentifier().toLowerCase();
        this.registeredCommands.put(name, command);
        command.getAliases().forEach(alias -> this.aliasesMap.put(alias.toLowerCase(), name));
    }

    public void registerHandler(CommandHandler handler) {
        String name = handler.getIdentifier().toLowerCase();
        this.registeredHandlers.put(name, handler);
        handler.getAliases().forEach(alias -> this.aliasesMap.put(alias.toLowerCase(), name));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!this.hasPermission(sender)) {
            this.noPermission(sender);
            return true;
        }
        if (args.length == 0) {
            this.noArgs(sender);
            return true;
        }
        String input = args[0].toLowerCase();
        CommandHandler handler = this.getHandler(input);
        if (handler != null) {
            if (!handler.hasPermission(sender)) {
                this.noPermission(sender);
            } else {
                handler.onCommand(sender, command, label, this.shortenArgs(args));
            }
            return true;
        }
        SubCommand<?> sub = this.getSubCommand(input);
        if (sub == null) {
            this.unknownCommand(sender, args);
        } else if (!sub.hasPermission(sender)) {
            this.noPermission(sender);
        } else {
            try {
                sub.execute(this.plugin, sender, this.shortenArgs(args));
            }
            catch (Exception ex) {
                this.onException(sender, sub, ex);
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        String input = args[0].toLowerCase();
        if (args.length == 1) {
            return this.getExecutors().stream().filter(e -> e.hasPermission(sender)).map(NamedExecutor::getIdentifier).filter(s -> StringUtil.startsWithIgnoreCase((String)s, (String)input)).collect(Collectors.toList());
        }
        CommandHandler handler = this.getHandler(input);
        if (handler != null && handler.hasPermission(sender)) {
            return handler.onTabComplete(sender, command, alias, this.shortenArgs(args));
        }
        SubCommand<?> sub = this.getSubCommand(input);
        if (sub != null && sub.hasPermission(sender)) {
            return sub.tabComplete(this.plugin, sender, this.shortenArgs(args));
        }
        return Collections.emptyList();
    }

    public List<NamedExecutor> getExecutors() {
        HashSet<NamedExecutor> executors = new HashSet<NamedExecutor>();
        executors.addAll(this.registeredHandlers.values());
        executors.addAll(this.registeredCommands.values());
        ArrayList<NamedExecutor> sortedExecutors = new ArrayList<NamedExecutor>(executors);
        sortedExecutors.sort(Comparator.comparing(NamedExecutor::getIdentifier));
        return sortedExecutors;
    }

    @Nullable
    protected CommandHandler getHandler(@NotNull String name) {
        CommandHandler fromName = this.registeredHandlers.get(name);
        if (fromName != null) {
            return fromName;
        }
        String nameFromAlias = this.aliasesMap.get(name);
        if (nameFromAlias == null) {
            return null;
        }
        return this.registeredHandlers.get(nameFromAlias);
    }

    @Nullable
    protected SubCommand<?> getSubCommand(@NotNull String name) {
        SubCommand<?> fromName = this.registeredCommands.get(name);
        if (fromName != null) {
            return fromName;
        }
        String nameFromAlias = this.aliasesMap.get(name);
        if (nameFromAlias == null) {
            return null;
        }
        return this.registeredCommands.get(nameFromAlias);
    }

    protected String[] shortenArgs(String[] args) {
        if (args.length == 0) {
            return args;
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args).subList(1, args.length));
        return argList.toArray(new String[0]);
    }
}

