/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.command;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class SimpleCompleter {
    @NotNull
    public static List<String> none() {
        return ImmutableList.of();
    }

    @NotNull
    public static List<String> objects(@NotNull String input, Collection<?> objects) {
        return SimpleCompleter.objects(input, objects.size(), objects);
    }

    @NotNull
    public static List<String> objects(@NotNull String input, int limit, Collection<?> objects) {
        return SimpleCompleter.objects(input, limit, objects.stream());
    }

    @NotNull
    public static List<String> objects(@NotNull String input, Stream<?> stream) {
        return SimpleCompleter.objects(input, 20, stream);
    }

    @NotNull
    public static List<String> objects(@NotNull String input, int limit, Stream<?> stream) {
        return stream.filter(Objects::nonNull).map(Object::toString).filter(s -> StringUtil.startsWithIgnoreCase((String)s, (String)input)).limit(Math.max(0, limit)).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> text(@NotNull String input, String ... texts) {
        return SimpleCompleter.text(input, texts.length, texts);
    }

    @NotNull
    public static List<String> text(@NotNull String input, int limit, String ... texts) {
        return SimpleCompleter.text(input, limit, Arrays.asList(texts));
    }

    @NotNull
    public static List<String> text(@NotNull String input, Collection<String> texts) {
        return SimpleCompleter.text(input, texts.size(), texts);
    }

    @NotNull
    public static List<String> text(@NotNull String input, int limit, Collection<String> texts) {
        return SimpleCompleter.objects(input, limit, texts);
    }

    @NotNull
    public static List<String> onlinePlayers(@NotNull String input) {
        return SimpleCompleter.onlinePlayers(input, 10);
    }

    @NotNull
    public static List<String> onlinePlayers(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName));
    }

    @NotNull
    public static List<String> allPlayers(@NotNull String input) {
        return SimpleCompleter.allPlayers(input, 10);
    }

    @NotNull
    public static List<String> allPlayers(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName));
    }

    @NotNull
    public static List<String> worlds(@NotNull String input) {
        return SimpleCompleter.worlds(input, 10);
    }

    @NotNull
    public static List<String> worlds(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Bukkit.getWorlds().stream().map(World::getName));
    }

    @NotNull
    public static List<String> materials(@NotNull String input) {
        return SimpleCompleter.materials(input, 10);
    }

    @NotNull
    public static List<String> materials(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Arrays.stream(Material.values()).map(Enum::name));
    }

    @NotNull
    public static List<String> effects(@NotNull String input) {
        return SimpleCompleter.effects(input, 10);
    }

    @NotNull
    public static List<String> effects(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName));
    }

    @NotNull
    public static List<String> enchantments(@NotNull String input) {
        return SimpleCompleter.effects(input, 10);
    }

    @NotNull
    public static List<String> enchantments(@NotNull String input, int limit) {
        return SimpleCompleter.objects(input, limit, Arrays.stream(Enchantment.values()).map(Enchantment::getName));
    }
}

