/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIListener;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUI {
    private static JavaPlugin plugin;
    private static final Map<UUID, GUI> openedGUIs;
    @NotNull
    protected final GUIType type;
    @NotNull
    protected String title;
    protected Inventory inv;
    protected final SortedMap<Integer, GUIItem> items = new TreeMap<Integer, GUIItem>();
    protected ItemStack emptyItem = null;
    protected boolean cancelOnTarget = true;
    protected boolean cancelOnSelf = true;
    protected boolean cancelOnOuter = true;
    protected final Map<String, Object> flags = new LinkedHashMap<String, Object>();
    protected GUIListener listener;

    public static void initialize(JavaPlugin plugin) {
        GUI.plugin = plugin;
    }

    public static JavaPlugin getPlugin() {
        return plugin;
    }

    public static Map<UUID, GUI> getOpenedGUIs() {
        return openedGUIs;
    }

    public GUI(@NotNull GUIType type, @NotNull String title) {
        this.type = type;
        this.title = ColorParser.parse(title);
    }

    public SortedMap<@NotNull Integer, @NotNull GUIItem> getItems() {
        return this.items;
    }

    public final void setItem(int index, @Nullable GUIItem item) {
        if (item == null) {
            this.items.remove(index);
        } else {
            this.items.put(index, item);
        }
    }

    public void setItemStack(int index, @Nullable ItemStack item) {
        this.setItem(index, item == null ? null : new GUIItem(item));
    }

    public void setItem(GUIItem item, int ... index) {
        for (int i : index) {
            this.setItem(i, item);
        }
    }

    public void setItemStack(ItemStack item, int ... index) {
        for (int i : index) {
            this.setItemStack(i, item);
        }
    }

    public void setItem(int row, int column, @NotNull GUIItem item) {
        if (row <= 0 || column <= 0) {
            throw new IllegalArgumentException("\u884c\u6570\u548c\u5217\u6570\u90fd\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u96f6");
        }
        if (row > this.type.getLines()) {
            throw new IllegalArgumentException("\u884c\u6570(" + row + ")\u5927\u4e8eGUI\u5927\u5c0f\u9650\u5236(" + this.type.getLines() + ")");
        }
        if (column > 9) {
            throw new IllegalArgumentException("\u5217\u6570(" + column + ")\u4e0d\u80fd\u5927\u4e8e9");
        }
        this.setItem(9 * (row - 1) + column - 1, item);
    }

    public GUIItem getItem(int index) {
        return (GUIItem)this.items.get(index);
    }

    public void setEmptyItem(ItemStack item) {
        this.emptyItem = item;
    }

    protected void fillEmptySlots(@NotNull Inventory inventory) {
        if (this.emptyItem == null) {
            return;
        }
        IntStream.range(0, inventory.getSize()).filter(i -> inventory.getItem(i) == null).forEach(index -> inventory.setItem(index, this.emptyItem));
    }

    protected void applyToInventory(Inventory inventory) {
        IntStream.range(0, inventory.getSize()).forEach(index -> inventory.setItem(index, new ItemStack(Material.AIR)));
        this.getItems().forEach((index, item) -> inventory.setItem(index.intValue(), item.getDisplay()));
        this.fillEmptySlots(inventory);
    }

    public void updateTitle(@NotNull String title) {
        this.title = ColorParser.parse(title);
        if (this.inv != null) {
            this.inv = Bukkit.createInventory(null, (int)this.type.getSize(), (String)this.title);
            this.applyToInventory(this.inv);
        }
    }

    public void updateView() {
        this.onUpdate();
        if (this.inv != null) {
            List viewers = this.inv.getViewers();
            this.applyToInventory(this.inv);
            viewers.forEach(p -> ((Player)p).updateInventory());
        }
    }

    public void setCancelOnTarget(boolean b) {
        this.cancelOnTarget = b;
    }

    public void setCancelOnSelf(boolean b) {
        this.cancelOnSelf = b;
    }

    public void setCancelOnOuter(boolean b) {
        this.cancelOnOuter = b;
    }

    public Object getFlag(String flag) {
        return this.flags.get(flag);
    }

    public void setFlag(String flag, Object obj) {
        this.flags.put(flag, obj);
    }

    public void removeFlag(String flag) {
        this.flags.remove(flag);
    }

    public void rawClickListener(InventoryClickEvent event) {
    }

    public void openGUI(Player player) {
        if (this.type == GUIType.CANCEL) {
            throw new IllegalStateException("\u88ab\u53d6\u6d88\u6216\u4e0d\u5b58\u5728\u7684GUI");
        }
        Inventory ui = Bukkit.createInventory(null, (int)this.type.getSize(), (String)this.title);
        this.applyToInventory(ui);
        GUI previous = GUI.getOpenedGUI(player);
        if (previous != null && previous.listener != null) {
            previous.listener.close(player);
        }
        GUI.setOpenedGUI(player, this);
        this.inv = ui;
        player.openInventory(ui);
        if (this.listener == null) {
            this.listener = new GUIListener(this);
            Bukkit.getPluginManager().registerEvents((Listener)this.listener, (Plugin)GUI.getPlugin());
        }
    }

    public void onDrag(InventoryDragEvent event) {
    }

    public void onClose() {
    }

    public void onUpdate() {
    }

    public GUIType getGUIType() {
        return this.type;
    }

    public String getGUIName() {
        return this.title;
    }

    public static void setOpenedGUI(Player player, GUI gui) {
        GUI.getOpenedGUIs().put(player.getUniqueId(), gui);
    }

    public static boolean hasOpenedGUI(Player player) {
        return GUI.getOpenedGUIs().containsKey(player.getUniqueId());
    }

    public static GUI getOpenedGUI(Player player) {
        return GUI.getOpenedGUIs().get(player.getUniqueId());
    }

    public static void removeOpenedGUI(Player player) {
        GUI.getOpenedGUIs().remove(player.getUniqueId());
    }

    public static void closeAll() {
        HashSet viewers = new HashSet();
        GUI.getOpenedGUIs().values().stream().flatMap(gui -> gui.inv.getViewers().stream()).forEach(viewers::add);
        viewers.forEach(HumanEntity::closeInventory);
        GUI.getOpenedGUIs().clear();
    }

    static {
        openedGUIs = new HashMap<UUID, GUI>();
    }
}

