/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class GUIListener
implements Listener {
    protected final GUI currentGUI;

    public GUIListener(GUI gui) {
        this.currentGUI = gui;
    }

    public GUI getCurrentGUI() {
        return this.currentGUI;
    }

    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!GUI.hasOpenedGUI(player)) {
            return;
        }
        if (GUI.getOpenedGUI(player) != this.getCurrentGUI()) {
            return;
        }
        this.getCurrentGUI().rawClickListener(event);
        if (event.getSlot() == -999 && this.getCurrentGUI().cancelOnOuter) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getClickedInventory().equals(this.getCurrentGUI().inv)) {
            GUIItem clickedItem;
            if (this.getCurrentGUI().cancelOnTarget) {
                event.setCancelled(true);
            }
            if (event.getSlot() != -999 && (clickedItem = this.getCurrentGUI().getItem(event.getSlot())) != null) {
                if (clickedItem.isActionActive()) {
                    clickedItem.onClick(player, event.getClick());
                    clickedItem.rawClickAction(event);
                    clickedItem.actions.forEach(action -> action.run(event.getClick(), player));
                }
                clickedItem.actionsIgnoreActive.forEach(action -> action.run(event.getClick(), player));
            }
        } else if (event.getClickedInventory().equals(player.getInventory()) && this.getCurrentGUI().cancelOnSelf) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (e.getInventory().equals(this.getCurrentGUI().inv) || e.getInventory().equals(e.getWhoClicked().getInventory())) {
            this.getCurrentGUI().onDrag(e);
        }
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (!event.getInventory().equals(this.getCurrentGUI().inv)) {
            return;
        }
        this.close((Player)event.getPlayer());
    }

    protected void close(Player p) {
        HandlerList.unregisterAll((Listener)this);
        this.getCurrentGUI().listener = null;
        GUI.removeOpenedGUI(p);
        this.getCurrentGUI().onClose();
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        GUI.removeOpenedGUI(event.getPlayer());
    }
}

