/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration.GUIActionType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration.GUIConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUIActionConfiguration {
    @NotNull
    protected final GUIActionType actionType;
    @Nullable
    protected final ClickType clickType;
    @Nullable
    protected final String actionContent;

    @NotNull
    public static GUIActionConfiguration of(@NotNull GUIActionType actionType, @Nullable ClickType clickType, @Nullable String actionContent) {
        return new GUIActionConfiguration(actionType, clickType, actionContent);
    }

    @NotNull
    public static GUIActionConfiguration of(@NotNull GUIActionType actionType, @Nullable String actionContent) {
        return GUIActionConfiguration.of(actionType, null, actionContent);
    }

    @NotNull
    public static GUIActionConfiguration of(@NotNull GUIActionType actionType, @Nullable ClickType clickType) {
        return GUIActionConfiguration.of(actionType, clickType, null);
    }

    @NotNull
    public static GUIActionConfiguration of(@NotNull GUIActionType actionType) {
        return GUIActionConfiguration.of(actionType, null, null);
    }

    public GUIActionConfiguration(@NotNull GUIActionType actionType, @Nullable ClickType clickType, @Nullable String actionContent) {
        this.clickType = clickType;
        this.actionType = actionType;
        this.actionContent = actionContent;
    }

    @Nullable
    public ClickType getClickType() {
        return this.clickType;
    }

    @NotNull
    public GUIActionType getActionType() {
        return this.actionType;
    }

    @Nullable
    public String getActionContent() {
        return this.actionContent;
    }

    public void checkAction(Player player, ClickType type) {
        if (this.getClickType() == null || this.getClickType() == type) {
            this.executeAction(player);
        }
    }

    public void executeAction(Player targetPlayer) {
        this.getActionType().getExecutor().accept(targetPlayer, this.getActionContent());
    }

    public GUIItem.GUIClickAction toClickAction() {
        return new GUIItem.GUIClickAction(){

            @Override
            public void run(ClickType type, Player player) {
                GUIActionConfiguration.this.checkAction(player, type);
            }
        };
    }

    @Nullable
    @Contract(value="null->null")
    public static GUIActionConfiguration deserialize(@Nullable String actionString) {
        GUIActionType actionType;
        if (actionString == null) {
            return null;
        }
        int prefixStart = actionString.indexOf("[");
        int prefixEnd = actionString.indexOf("]");
        if (prefixStart < 0 || prefixEnd < 0) {
            return null;
        }
        String prefix = actionString.substring(prefixStart + 1, prefixEnd);
        ClickType clickType = null;
        if (prefix.contains(":")) {
            String[] args = prefix.split(":");
            clickType = GUIConfiguration.readClickType(args[0]);
            actionType = GUIActionType.readActionType(args[1]);
        } else {
            actionType = GUIActionType.readActionType(prefix);
        }
        if (actionType == null) {
            return null;
        }
        String content = actionString.substring(prefixEnd + 1).trim();
        return GUIActionConfiguration.of(actionType, clickType, content);
    }

    @NotNull
    public String serialize() {
        String prefix = "[" + this.getActionType().name() + (this.getClickType() == null ? "" : ":" + this.getClickType().name()) + "]";
        String content = this.getActionContent() == null ? "" : " " + this.getActionContent();
        return prefix + content;
    }
}

