/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration;

import com.artformgames.plugin.residencelist.lib.easyplugin.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GUIActionType {
    CHAT((player, string) -> {
        if (string == null) {
            return;
        }
        MessageUtils.setPlaceholders((CommandSender)player, Collections.singletonList(string)).forEach(arg_0 -> ((Player)player).chat(arg_0));
    }),
    CONSOLE((player, string) -> {
        if (string == null) {
            return;
        }
        MessageUtils.setPlaceholders((CommandSender)player, Collections.singletonList(string)).forEach(message -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)message));
    }),
    MESSAGE((x$0, xva$1) -> MessageUtils.send(x$0, xva$1)),
    SOUND((player, string) -> {
        if (string == null) {
            return;
        }
        try {
            String[] stringArray;
            if (string.contains(":")) {
                stringArray = string.split(":");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            }
            String[] args = stringArray;
            Sound sound = Arrays.stream(Sound.values()).filter(s -> s.name().equals(args[0])).findFirst().orElse(null);
            if (sound == null) {
                return;
            }
            float volume = args.length > 1 ? Float.parseFloat(args[1]) : 1.0f;
            float pitch = args.length > 2 ? Float.parseFloat(args[2]) : 1.0f;
            player.playSound(player.getLocation(), sound, volume, pitch);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }),
    CLOSE((player, string) -> player.closeInventory());

    BiConsumer<@NotNull Player, @Nullable String> executor;

    private GUIActionType(BiConsumer<Player, String> executor) {
        this.executor = executor;
    }

    public BiConsumer<@NotNull Player, @Nullable String> getExecutor() {
        return this.executor;
    }

    public static GUIActionType readActionType(String string) {
        return Arrays.stream(GUIActionType.values()).filter(action -> action.name().equalsIgnoreCase(string)).findFirst().orElse(null);
    }
}

