/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.configuration.GUIActionConfiguration;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ItemStackFactory;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUIItemConfiguration {
    @Nullable
    ItemStack original;
    @NotNull
    Material type;
    int amount;
    int data;
    @Nullable
    String name;
    @NotNull
    List<String> lore;
    @NotNull
    List<Integer> slots;
    @NotNull
    List<GUIActionConfiguration> actions;

    public GUIItemConfiguration(@NotNull Material type, int amount, int data, @Nullable String name, @NotNull List<String> lore, @NotNull List<GUIActionConfiguration> actions, @NotNull List<Integer> slots) {
        this(null, type, amount, data, name, lore, actions, slots);
    }

    public GUIItemConfiguration(@Nullable ItemStack original, @NotNull Material type, int amount, int data, @Nullable String name, @NotNull List<String> lore, @NotNull List<GUIActionConfiguration> actions, @NotNull List<Integer> slots) {
        this.original = original;
        this.type = type;
        this.amount = amount;
        this.data = data;
        this.name = name;
        this.lore = lore;
        this.slots = slots;
        this.actions = actions;
    }

    public void setupItems(Player player, GUI gui) {
        ItemStack itemStack;
        if (this.original != null) {
            ItemStack tmp = this.original.clone();
            ItemMeta originalMeta = this.original.getItemMeta();
            if (originalMeta != null) {
                if (originalMeta.hasDisplayName()) {
                    originalMeta.setDisplayName(this.parseText(player, originalMeta.getDisplayName()));
                }
                if (originalMeta.getLore() != null) {
                    originalMeta.setLore(this.parseTexts(player, originalMeta.getLore()));
                }
            }
            tmp.setItemMeta(originalMeta);
            itemStack = tmp;
        } else {
            ItemStackFactory icon = new ItemStackFactory(this.type, this.amount, this.data);
            if (this.name != null) {
                icon.setDisplayName(this.parseText(player, this.name));
            }
            if (!this.lore.isEmpty()) {
                icon.setLore(this.parseTexts(player, this.lore));
            }
            itemStack = icon.toItemStack();
        }
        GUIItem item = new GUIItem(itemStack);
        this.actions.stream().map(GUIActionConfiguration::toClickAction).forEach(item::addClickAction);
        this.slots.forEach(slot -> gui.setItem((int)slot, item));
    }

    private List<String> parseTexts(Player player, List<String> lore) {
        return ColorParser.parse(MessageUtils.setPlaceholders((CommandSender)player, lore));
    }

    @NotNull
    private String parseText(Player player, @NotNull String name) {
        return ColorParser.parse(MessageUtils.setPlaceholders((CommandSender)player, name));
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.original != null) {
            map.put("original", this.original);
        } else {
            map.put("type", this.type.name());
            if (this.data != 0) {
                map.put("data", this.data);
            }
        }
        if (this.name != null) {
            map.put("name", this.name);
        }
        if (this.amount != 1) {
            map.put("amount", this.amount);
        }
        if (!this.lore.isEmpty()) {
            map.put("lore", this.lore);
        }
        if (this.slots.size() > 1) {
            map.put("slots", this.slots);
        } else if (this.slots.size() == 1) {
            map.put("slot", this.slots.get(0));
        }
        if (!this.actions.isEmpty()) {
            map.put("actions", this.actions.stream().map(GUIActionConfiguration::serialize).collect(Collectors.toList()));
        }
        return map;
    }

    @Nullable
    public static GUIItemConfiguration readFrom(@Nullable ConfigurationSection itemSection) {
        if (itemSection == null) {
            return null;
        }
        ItemStack original = null;
        if (itemSection.contains("original")) {
            original = itemSection.getItemStack("original");
        }
        String material = Optional.ofNullable(itemSection.getString("type")).orElse("STONE");
        Material type = Optional.ofNullable(Material.matchMaterial((String)material)).orElse(Material.STONE);
        int data = itemSection.getInt("data", 0);
        int amount = itemSection.getInt("amount", 1);
        String name = itemSection.getString("name");
        List lore = itemSection.getStringList("lore");
        List<Integer> slots = itemSection.getIntegerList("slots");
        int slot = itemSection.getInt("slot", 0);
        List actionsString = itemSection.getStringList("actions");
        ArrayList<GUIActionConfiguration> actions = new ArrayList<GUIActionConfiguration>();
        for (String actionString : actionsString) {
            GUIActionConfiguration action = GUIActionConfiguration.deserialize(actionString);
            if (action == null) continue;
            actions.add(action);
        }
        return new GUIItemConfiguration(original, type, amount, data, name, lore, actions, slots.size() > 0 ? slots : Collections.singletonList(slot));
    }
}

