/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.CommonPagedGUI;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoPagedGUI
extends CommonPagedGUI {
    public static Function<Player, ItemStack> defaultPreviousPage = null;
    public static Function<Player, ItemStack> defaultNextPage = null;
    protected ItemStack previousPageUI;
    protected ItemStack nextPageUI;
    protected ItemStack noPreviousPageUI;
    protected ItemStack noNextPageUI;
    protected int previousPageSlot = -1;
    protected int nextPageSlot = -1;

    public AutoPagedGUI(@NotNull GUIType type, @NotNull String title, int[] range) {
        super(type, title, range);
    }

    public AutoPagedGUI(@NotNull GUIType type, @NotNull String title, int a, int b) {
        super(type, title, a, b);
    }

    public void setPreviousPageUI(@Nullable ItemStack lastPageUI) {
        this.previousPageUI = lastPageUI;
    }

    public void setNoPreviousPageUI(@Nullable ItemStack noPreviousPageUI) {
        this.noPreviousPageUI = noPreviousPageUI;
    }

    public void setNextPageUI(@Nullable ItemStack nextPageUI) {
        this.nextPageUI = nextPageUI;
    }

    public void setNoNextPageUI(@Nullable ItemStack noNextPageUI) {
        this.noNextPageUI = noNextPageUI;
    }

    public void setPreviousPageSlot(int slot) {
        this.previousPageSlot = slot;
    }

    public void setNextPageSlot(int slot) {
        this.nextPageSlot = slot;
    }

    @Override
    protected void fillEmptySlots(@NotNull Inventory inventory) {
        if (this.emptyItem == null) {
            return;
        }
        Set rangeSet = Arrays.stream(this.range).boxed().collect(Collectors.toSet());
        if (this.previousPageSlot >= 0) {
            rangeSet.add(this.previousPageSlot);
        }
        if (this.nextPageSlot >= 0) {
            rangeSet.add(this.nextPageSlot);
        }
        IntStream.range(0, inventory.getSize()).filter(i -> inventory.getItem(i) == null).filter(i -> !rangeSet.contains(i)).forEach(index -> inventory.setItem(index, this.emptyItem));
    }

    @Override
    public void openGUI(final Player user) {
        if (this.previousPageSlot >= 0) {
            if (this.hasPreviousPage()) {
                Object finalPreviousPageUI = this.previousPageUI != null ? this.previousPageUI : (defaultPreviousPage != null ? defaultPreviousPage.apply(user) : null);
                this.setItem(this.previousPageSlot, new GUIItem((ItemStack)finalPreviousPageUI){

                    @Override
                    public void onClick(Player clicker, ClickType type) {
                        if (type == ClickType.RIGHT) {
                            AutoPagedGUI.this.goFirstPage();
                        } else {
                            AutoPagedGUI.this.goPreviousPage();
                        }
                        AutoPagedGUI.this.openGUI(user);
                    }
                });
            } else {
                this.setItem(this.previousPageSlot, this.noPreviousPageUI == null ? null : new GUIItem(this.noPreviousPageUI));
            }
        }
        if (this.nextPageSlot >= 0) {
            if (this.hasNextPage()) {
                Object finalNextPageUI = this.previousPageUI != null ? this.nextPageUI : (defaultNextPage != null ? defaultNextPage.apply(user) : null);
                this.setItem(this.nextPageSlot, new GUIItem((ItemStack)finalNextPageUI){

                    @Override
                    public void onClick(Player clicker, ClickType type) {
                        if (type == ClickType.RIGHT) {
                            AutoPagedGUI.this.goLastPage();
                        } else {
                            AutoPagedGUI.this.goNextPage();
                        }
                        AutoPagedGUI.this.openGUI(user);
                    }
                });
            } else {
                this.setItem(this.nextPageSlot, this.noNextPageUI == null ? null : new GUIItem(this.noNextPageUI));
            }
        }
        super.openGUI(user);
    }
}

