/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.PagedGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class CommonPagedGUI
extends PagedGUI {
    protected final int[] range;

    public CommonPagedGUI(@NotNull GUIType type, @NotNull String title, int a, int b) {
        this(type, title, CommonPagedGUI.toRange(type, a, b));
    }

    public CommonPagedGUI(@NotNull GUIType type, @NotNull String title, int[] range) {
        super(type, title);
        Arrays.sort(range);
        this.range = range;
    }

    @Override
    protected void fillEmptySlots(@NotNull Inventory inventory) {
        if (this.emptyItem == null) {
            return;
        }
        Set rangeSet = Arrays.stream(this.range).boxed().collect(Collectors.toSet());
        IntStream.range(0, inventory.getSize()).filter(i -> inventory.getItem(i) == null).filter(i -> !rangeSet.contains(i)).forEach(index -> inventory.setItem(index, this.emptyItem));
    }

    private static int getLine(int i) {
        return i / 9 + 1;
    }

    private static int getColumn(int i) {
        return i % 9 + 1;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.page > 1;
    }

    @Override
    public boolean hasNextPage() {
        return this.page < this.getLastPageNumber();
    }

    public void goFirstPage() {
        this.page = 1;
        this.onPageChange(this.page);
    }

    public void goLastPage() {
        this.page = this.getLastPageNumber();
        this.onPageChange(this.page);
    }

    @Override
    public int getLastPageNumber() {
        return this.getLastPageNumber(this.range.length);
    }

    public int getFirstPageNumber() {
        return 1;
    }

    @Override
    public void openGUI(Player player) {
        int start;
        int i;
        if (this.container.isEmpty()) {
            super.openGUI(player);
            return;
        }
        if (this.page > this.getLastPageNumber()) {
            this.page = this.getLastPageNumber();
        }
        ArrayList list = new ArrayList();
        for (i = start = (this.page - 1) * this.range.length; i < start + this.range.length && i < this.container.size(); ++i) {
            list.add(this.container.get(i));
        }
        i = 0;
        Arrays.stream(this.range).forEach(index -> this.setItem(index, null));
        for (int index2 : this.range) {
            if (i >= list.size()) break;
            this.setItem(index2, (GUIItem)list.get(i));
            ++i;
        }
        super.openGUI(player);
    }

    private static int[] toRange(GUIType type, int a, int b) {
        if (a > b) {
            a ^= b;
            b = a ^ b;
            a ^= b;
        }
        int lineA = CommonPagedGUI.getLine(a);
        int columnA = CommonPagedGUI.getColumn(a);
        int lineB = CommonPagedGUI.getLine(b);
        int columnB = CommonPagedGUI.getColumn(b);
        if (lineB > type.getLines()) {
            throw new IndexOutOfBoundsException("\u9875\u9762\u5185\u5bb9\u8303\u56f4\u8d85\u8fc7\u4e86GUI\u7684\u5927\u5c0f");
        }
        int[] range = new int[(lineB - lineA + 1) * (columnB - columnA + 1)];
        int l = 0;
        for (int i = 0; i < type.getSize(); ++i) {
            int li = CommonPagedGUI.getLine(i);
            int ci = CommonPagedGUI.getColumn(i);
            if (li < lineA || li > lineB || ci < columnA || ci > columnB) continue;
            range[l] = i;
            ++l;
        }
        return range;
    }
}

