/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged;

import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class PagedGUI
extends GUI {
    protected List<GUIItem> container = new ArrayList<GUIItem>();
    protected int page = 1;

    protected PagedGUI(@NotNull GUIType type, @NotNull String title) {
        super(type, title);
    }

    public int setCurrentPage(int page) {
        this.page = Math.max(1, page);
        return this.page;
    }

    public int getCurrentPage() {
        return this.page;
    }

    public int getLastPageNumber() {
        return this.getLastPageNumber(this.getGUIType().getSize());
    }

    public int getLastPageNumber(int size) {
        return this.container.size() / size + (this.container.size() % size == 0 ? 0 : 1);
    }

    public int addItem(@NotNull GUIItem i) {
        this.container.add(i);
        return this.container.size() - 1;
    }

    public int addItem(int index, @NotNull GUIItem i) {
        this.container.add(index, i);
        return this.container.size() - 1;
    }

    public int addItemStack(@NotNull ItemStack itemStack) {
        return this.addItem(new GUIItem(itemStack));
    }

    public void removeItem(@NotNull GUIItem item) {
        this.container.remove(item);
    }

    public void removeItem(int index) {
        this.container.remove(index);
    }

    @NotNull
    public List<GUIItem> getPagedContainer() {
        return this.container;
    }

    public void onPageChange(int pageNum) {
    }

    public void goPreviousPage() {
        if (this.hasPreviousPage()) {
            --this.page;
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.onPageChange(this.page);
    }

    public void goNextPage() {
        if (this.hasNextPage()) {
            ++this.page;
        } else {
            throw new IndexOutOfBoundsException();
        }
        this.onPageChange(this.page);
    }

    public abstract boolean hasPreviousPage();

    public abstract boolean hasNextPage();
}

