/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.i18n;

import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EasyPluginMessageProvider {
    public static final EasyPluginMessageProvider ZH_CN = new zh_CN();
    public static final EasyPluginMessageProvider EN_US = new en_US();

    public String loading(Plugin var1);

    public String loaded(Plugin var1, long var2);

    public String enabling(Plugin var1);

    public String enableSuccess(Plugin var1, long var2);

    public String enableFailure(Plugin var1, long var2);

    public String disabling(Plugin var1);

    public String disabled(Plugin var1, long var2);

    default public void print(@NotNull Plugin plugin, @Nullable String prefix, String ... messages) {
        Arrays.stream(messages).map(message -> "[" + plugin.getName() + "] " + (prefix == null ? "" : prefix) + message).map(ColorParser::parse).forEach(message -> Bukkit.getConsoleSender().sendMessage(message));
    }

    public static class en_US
    implements EasyPluginMessageProvider {
        @Override
        public String loading(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " loading...";
        }

        @Override
        public String loaded(Plugin plugin, long startMillis) {
            return "&fLoaded after " + (System.currentTimeMillis() - startMillis) + " ms.";
        }

        @Override
        public String enabling(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " enabling...";
        }

        @Override
        public String enableSuccess(Plugin plugin, long startMillis) {
            return "&aEnabled successfully!&f Cost " + (System.currentTimeMillis() - startMillis) + " ms.";
        }

        @Override
        public String enableFailure(Plugin plugin, long startMillis) {
            return "&cEnabled failed after " + (System.currentTimeMillis() - startMillis) + " ms.";
        }

        @Override
        public String disabling(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " begin to shutdown...";
        }

        @Override
        public String disabled(Plugin plugin, long startMillis) {
            return "&fShutdown successfully, cost " + (System.currentTimeMillis() - startMillis) + " ms.";
        }
    }

    public static class zh_CN
    implements EasyPluginMessageProvider {
        @Override
        public String loading(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " \u5f00\u59cb\u52a0\u8f7d...";
        }

        @Override
        public String loaded(Plugin plugin, long startMillis) {
            return "&f\u52a0\u8f7d\u5b8c\u6210 \uff0c\u5171\u8017\u65f6 " + (System.currentTimeMillis() - startMillis) + " ms \u3002";
        }

        @Override
        public String enabling(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " \u5f00\u59cb\u542f\u52a8...";
        }

        @Override
        public String enableSuccess(Plugin plugin, long startMillis) {
            return "&a\u542f\u7528\u5b8c\u6210! &f\u5171\u8017\u65f6 " + (System.currentTimeMillis() - startMillis) + " ms \u3002";
        }

        @Override
        public String enableFailure(Plugin plugin, long startMillis) {
            return "&c\u542f\u7528\u5931\u8d25! &f\u5df2\u8017\u65f6 " + (System.currentTimeMillis() - startMillis) + " ms \u3002";
        }

        @Override
        public String disabling(Plugin plugin) {
            return "&f" + plugin.getName() + " " + plugin.getDescription().getVersion() + " \u5f00\u59cb\u5378\u8f7d...";
        }

        @Override
        public String disabled(Plugin plugin, long startMillis) {
            return "&f\u5378\u8f7d\u5b8c\u6210! \u5171\u8017\u65f6 " + (System.currentTimeMillis() - startMillis) + " ms \u3002";
        }
    }
}

