/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.papi.expansion;

import com.artformgames.plugin.residencelist.lib.easyplugin.papi.EasyPlaceholder;
import com.artformgames.plugin.residencelist.lib.easyplugin.papi.expansion.EasyExpansion;
import com.artformgames.plugin.residencelist.lib.easyplugin.papi.expansion.SubExpansion;
import com.artformgames.plugin.residencelist.lib.easyplugin.papi.handler.PlaceholderHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SectionExpansion
implements EasyExpansion {
    protected final EasyPlaceholder root;
    @NotNull
    protected final String identifier;
    @NotNull
    protected final List<String> aliases;
    @NotNull
    protected final Map<String, SectionExpansion> registeredSections = new HashMap<String, SectionExpansion>();
    @NotNull
    protected final Map<String, SubExpansion<?>> registeredExpansions = new HashMap();
    @NotNull
    protected final Map<String, String> aliasesMap = new HashMap<String, String>();

    public SectionExpansion(@NotNull EasyPlaceholder root, @NotNull String identifier, String ... aliases) {
        this(root, identifier, Arrays.asList(aliases));
    }

    public SectionExpansion(@NotNull EasyPlaceholder root, @NotNull String identifier, @NotNull List<String> aliases) {
        this.root = root;
        this.identifier = identifier;
        this.aliases = aliases;
    }

    public EasyPlaceholder getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public void register(@NotNull SubExpansion<?> placeholder) {
        String name = placeholder.getIdentifier().toLowerCase();
        this.registeredExpansions.put(name, placeholder);
        placeholder.getAliases().forEach(alias -> this.aliasesMap.put(alias.toLowerCase(), name));
    }

    public final void register(@NotNull SectionExpansion placeholder) {
        String name = placeholder.getIdentifier().toLowerCase();
        this.registeredSections.put(name, placeholder);
        placeholder.getAliases().forEach(alias -> this.aliasesMap.put(alias.toLowerCase(), name));
    }

    public final void handle(@NotNull String identifier, @NotNull PlaceholderHandler handler, String ... aliases) {
        this.handle(identifier, handler, Collections.emptyList(), aliases);
    }

    public final void handle(@NotNull String identifier, @NotNull PlaceholderHandler handler, @NotNull Consumer<ArrayList<String>> paramsConsumer, String ... aliases) {
        this.handle(identifier, handler, () -> {
            ArrayList params = new ArrayList();
            paramsConsumer.accept(params);
            return params;
        }, aliases);
    }

    public final void handle(@NotNull String identifier, @NotNull PlaceholderHandler handler, @NotNull List<String> availableParams, String ... aliases) {
        this.handle(identifier, handler, () -> availableParams, aliases);
    }

    public final void handle(@NotNull String identifier, final @NotNull PlaceholderHandler handler, final @NotNull Supplier<List<String>> availableParams, String ... aliases) {
        this.register(new SubExpansion<SectionExpansion>(this, identifier, aliases){

            @Override
            public Object handle(@Nullable OfflinePlayer player, @NotNull String[] args) throws Exception {
                return handler.handle(player, args);
            }

            @Override
            public List<String> listAvailableParams() {
                return (List)availableParams.get();
            }
        });
    }

    public final void handleSection(@NotNull String section, @NotNull Consumer<SectionExpansion> consumer, String ... aliases) {
        SectionExpansion sectionExpansion = new SectionExpansion(this.getRoot(), section, aliases);
        consumer.accept(sectionExpansion);
        this.register(sectionExpansion);
    }

    @Nullable
    public final Object handleRequest(@Nullable OfflinePlayer player, @NotNull String[] args) {
        if (args.length == 0) {
            return this.getRoot().onErrorParams(player);
        }
        String input = args[0].toLowerCase();
        SectionExpansion group = this.getHandler(input);
        if (group != null) {
            return group.handleRequest(player, this.shortenArgs(args));
        }
        SubExpansion<?> sub = this.getSubPlaceholder(input);
        if (sub == null) {
            return this.getRoot().onErrorParams(player);
        }
        try {
            return sub.handle(player, this.shortenArgs(args));
        }
        catch (Exception ex) {
            return this.getRoot().onException(player, sub, ex);
        }
    }

    public List<String> listPlaceholders() {
        ArrayList<String> placeholders = new ArrayList<String>();
        String currentID = this.getIdentifier();
        for (SectionExpansion sectionExpansion : this.registeredSections.values()) {
            for (String groupID : sectionExpansion.listPlaceholders()) {
                placeholders.add(currentID + "_" + groupID);
            }
        }
        for (SubExpansion subExpansion : this.registeredExpansions.values()) {
            String identifier = subExpansion.getIdentifier();
            List<String> params = subExpansion.listAvailableParams();
            if (params.isEmpty()) {
                placeholders.add(currentID + "_" + identifier);
                continue;
            }
            for (String param : params) {
                placeholders.add(currentID + "_" + identifier + "_" + param);
            }
        }
        return placeholders;
    }

    @Nullable
    protected SectionExpansion getHandler(@NotNull String name) {
        SectionExpansion fromName = this.registeredSections.get(name);
        if (fromName != null) {
            return fromName;
        }
        String nameFromAlias = this.aliasesMap.get(name);
        if (nameFromAlias == null) {
            return null;
        }
        return this.registeredSections.get(nameFromAlias);
    }

    @Nullable
    protected SubExpansion<?> getSubPlaceholder(@NotNull String name) {
        SubExpansion<?> fromName = this.registeredExpansions.get(name);
        if (fromName != null) {
            return fromName;
        }
        String nameFromAlias = this.aliasesMap.get(name);
        if (nameFromAlias == null) {
            return null;
        }
        return this.registeredExpansions.get(nameFromAlias);
    }

    protected String[] shortenArgs(String[] args) {
        if (args.length == 0) {
            return args;
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args).subList(1, args.length));
        return argList.toArray(new String[0]);
    }
}

