/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.user;

import com.artformgames.plugin.residencelist.lib.easyplugin.EasyPlugin;
import com.artformgames.plugin.residencelist.lib.easyplugin.user.AbstractUserData;
import com.artformgames.plugin.residencelist.lib.easyplugin.user.UserDataRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserDataManager<K, U extends AbstractUserData<K>>
implements UserDataRegistry<K, U> {
    @NotNull
    protected final EasyPlugin plugin;
    @NotNull
    protected final ExecutorService executor;
    @NotNull
    protected final Map<K, U> dataCache;

    public UserDataManager(@NotNull EasyPlugin plugin) {
        this(plugin, Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(plugin.getName() + "-UserManager");
            return t;
        }), new ConcurrentHashMap());
    }

    public UserDataManager(@NotNull EasyPlugin plugin, @NotNull ExecutorService executor) {
        this(plugin, executor, new ConcurrentHashMap());
    }

    public UserDataManager(@NotNull EasyPlugin plugin, @NotNull ExecutorService executor, @NotNull Map<K, U> cacheMap) {
        this.plugin = plugin;
        this.executor = executor;
        this.dataCache = cacheMap;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @NotNull
    protected EasyPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.getPlugin().getLogger();
    }

    @NotNull
    public abstract U emptyUser(@NotNull K var1);

    @NotNull
    public U errorUser(@NotNull K key) {
        return this.emptyUser(key);
    }

    @Nullable
    protected abstract U loadData(@NotNull K var1) throws Exception;

    protected abstract void saveData(@NotNull U var1) throws Exception;

    @Override
    @NotNull
    public Map<K, U> cache() {
        return this.dataCache;
    }

    @Override
    @NotNull
    public CompletableFuture<U> load(@NotNull K key, @NotNull Supplier<Boolean> cacheCondition) {
        AbstractUserData cached = (AbstractUserData)this.getNullable(key);
        if (cached != null) {
            return CompletableFuture.supplyAsync(() -> cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            String identifier = this.serializeKey(key);
            try {
                long s1 = System.currentTimeMillis();
                this.getPlugin().debug("\u5f00\u59cb\u52a0\u8f7d\u7528\u6237 " + identifier + " \u7684\u6570\u636e...");
                U data = this.loadData(key);
                if (data == null) {
                    this.getPlugin().debug("\u6570\u636e\u5e93\u5185\u4e0d\u5b58\u5728\u7528\u6237 " + identifier + " \u7684\u6570\u636e\uff0c\u89c6\u4f5c\u65b0\u6863\u6848\u3002");
                    return this.emptyUser(key);
                }
                this.getPlugin().debug("\u52a0\u8f7d\u7528\u6237 " + identifier + " \u7684\u6570\u636e\u5b8c\u6210\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - s1) + " ms.");
                return data;
            }
            catch (Exception ex) {
                this.getPlugin().error("\u52a0\u8f7d\u7528\u6237 " + this.serializeKey(key) + " \u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\uff01");
                ex.printStackTrace();
                return this.errorUser(key);
            }
        }, this.executor).thenApply(data -> {
            if (((Boolean)cacheCondition.get()).booleanValue() && !data.isDropping()) {
                this.dataCache.put(key, data);
            }
            return data;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> save(@NotNull U user) {
        return CompletableFuture.supplyAsync(() -> {
            String identifier = this.serializeKey(user.key());
            try {
                long s1 = System.currentTimeMillis();
                this.getPlugin().debug("\u5f00\u59cb\u4fdd\u5b58\u7528\u6237 " + identifier + " \u7684\u6570\u636e...");
                this.saveData(user);
                this.getPlugin().debug("\u4fdd\u5b58\u7528\u6237 " + identifier + " \u7684\u6570\u636e\u5b8c\u6210\uff0c\u8017\u65f6 " + (System.currentTimeMillis() - s1) + " ms.");
                return true;
            }
            catch (Exception ex) {
                this.getPlugin().error("\u4fdd\u5b58\u7528\u6237 " + identifier + " \u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\uff01");
                ex.printStackTrace();
                return false;
            }
        }, this.executor);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> unload(@NotNull K key, boolean save) {
        AbstractUserData data = (AbstractUserData)this.getNullable(key);
        if (data == null) {
            return CompletableFuture.completedFuture(false);
        }
        data.setDropping(true);
        if (save) {
            return this.save((U)data).thenApply(result -> {
                if (data.isDropping()) {
                    this.dataCache.remove(key);
                }
                return result;
            });
        }
        this.dataCache.remove(key);
        return CompletableFuture.completedFuture(true);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> modify(@NotNull K key, @NotNull Consumer<U> consumer) {
        AbstractUserData cached = (AbstractUserData)this.getNullable(key);
        if (cached != null) {
            return CompletableFuture.supplyAsync(() -> {
                consumer.accept(cached);
                return true;
            }, this.executor);
        }
        return ((CompletableFuture)this.load(key, true).thenApply(data -> {
            consumer.accept(data);
            return data;
        })).thenCompose(data -> this.unload(key, true));
    }

    @Override
    @NotNull
    public <V> CompletableFuture<V> peek(@NotNull K key, @NotNull Function<U, V> function) {
        AbstractUserData cached = (AbstractUserData)this.getNullable(key);
        if (cached != null) {
            return CompletableFuture.supplyAsync(() -> function.apply(cached), this.executor);
        }
        return this.load(key, false).thenApply(function);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<Map<K, U>> loadGroup(@NotNull Collection<? extends T> users, @NotNull Function<? super T, ? extends K> function, @NotNull Predicate<T> cacheCondition) {
        CompletionStage<Map<K, Object>> task = CompletableFuture.completedFuture(new ConcurrentHashMap());
        if (users.isEmpty()) {
            return task;
        }
        Map usersMap = users.stream().collect(Collectors.toMap(function, Function.identity()));
        for (Map.Entry entry : usersMap.entrySet()) {
            Object key = entry.getKey();
            Object user = entry.getValue();
            task = task.thenCombine(this.load(key, () -> cacheCondition.test(user)), (map, result) -> {
                map.put(key, result);
                return map;
            });
        }
        return task.thenApply(Collections::unmodifiableMap);
    }

    @Override
    public void saveAll() {
        if (this.cache().isEmpty()) {
            return;
        }
        for (AbstractUserData u : this.cache().values()) {
            try {
                this.saveData(u);
            }
            catch (Exception e) {
                this.getPlugin().error("\u4fdd\u5b58\u7528\u6237 " + this.serializeKey(u.key()) + " \u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\uff01");
                e.printStackTrace();
            }
        }
    }

    @Override
    public int unloadAll(boolean save) {
        if (save) {
            this.saveAll();
        }
        int size = this.cache().size();
        this.cache().clear();
        return size;
    }
}

