/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.user;

import com.artformgames.plugin.residencelist.lib.easyplugin.user.UserData;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface UserDataRegistry<K, U extends UserData<K>> {
    public void shutdown();

    @NotNull
    public Logger getLogger();

    @NotNull
    public Map<K, U> cache();

    default public String serializeKey(@NotNull K key) {
        return key.toString();
    }

    @NotNull
    default public CompletableFuture<U> load(@NotNull K key) {
        return this.load(key, false);
    }

    @NotNull
    default public CompletableFuture<U> load(@NotNull K key, boolean cache) {
        return this.load(key, () -> cache);
    }

    default public @Unmodifiable @NotNull Set<U> list() {
        return ImmutableSet.copyOf(this.cache().values());
    }

    @NotNull
    default public U get(@NotNull K key) {
        return (U)((UserData)Optional.ofNullable(this.getNullable(key)).orElseThrow(() -> new NullPointerException("User " + key + " not found.")));
    }

    @Nullable
    default public U getNullable(@NotNull K key) {
        return (U)((UserData)this.cache().get(key));
    }

    default public @NotNull Optional<@Nullable U> getOptional(@NotNull K key) {
        return Optional.ofNullable(this.getNullable(key));
    }

    @NotNull
    public CompletableFuture<U> load(@NotNull K var1, @NotNull Supplier<Boolean> var2);

    @NotNull
    public CompletableFuture<Boolean> save(@NotNull U var1);

    @NotNull
    default public CompletableFuture<Boolean> unload(@NotNull K key) {
        return this.unload(key, true);
    }

    @NotNull
    public CompletableFuture<Boolean> unload(@NotNull K var1, boolean var2);

    @NotNull
    public CompletableFuture<Boolean> modify(@NotNull K var1, @NotNull Consumer<U> var2);

    @NotNull
    public <V> CompletableFuture<V> peek(@NotNull K var1, @NotNull Function<U, V> var2);

    @NotNull
    default public CompletableFuture<Map<K, U>> loadOnline(@NotNull Function<Player, ? extends K> function) {
        return this.loadGroup(Bukkit.getOnlinePlayers(), function, OfflinePlayer::isOnline);
    }

    @NotNull
    public <T> CompletableFuture<Map<K, U>> loadGroup(@NotNull Collection<? extends T> var1, @NotNull Function<? super T, ? extends K> var2, @NotNull Predicate<T> var3);

    @NotNull
    default public CompletableFuture<Map<K, U>> loadGroup(@NotNull Collection<K> allKeys, @NotNull Predicate<K> cacheCondition) {
        return this.loadGroup(allKeys, Function.identity(), cacheCondition);
    }

    @NotNull
    default public CompletableFuture<Map<K, U>> loadGroup(@NotNull Collection<K> allKeys) {
        return this.loadGroup(allKeys, v -> false);
    }

    public void saveAll();

    public int unloadAll(boolean var1);
}

