/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.utils;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class EasyCooldown<P, K> {
    protected final NumberFormat numberFormatter;
    @NotNull
    protected final Map<K, Long> cooldown = new HashMap<K, Long>();
    @NotNull
    protected final Function<P, K> providerToKey;
    protected long defaultDuration;

    public EasyCooldown(@NotNull Function<P, K> providerToKey) {
        this(EasyCooldown.defaultFormatter(), providerToKey, 1000L);
    }

    public EasyCooldown(@NotNull NumberFormat numberFormatter, @NotNull Function<P, K> providerToKey) {
        this(numberFormatter, providerToKey, 1000L);
    }

    public EasyCooldown(@NotNull NumberFormat numberFormatter, @NotNull Function<P, K> providerToKey, long defaultDuration) {
        this.numberFormatter = numberFormatter;
        this.providerToKey = providerToKey;
        this.defaultDuration = defaultDuration;
    }

    public long getCooldown(@NotNull P provider) {
        Long time = this.cooldown.get(this.providerToKey.apply(provider));
        if (time == null || time < 0L) {
            return 0L;
        }
        long duration = this.getDuration(provider);
        if (duration <= 0L) {
            return 0L;
        }
        long past = System.currentTimeMillis() - time;
        return duration - past;
    }

    @NotNull
    public String getCooldownSeconds(@NotNull P provider) {
        return this.formatSeconds(this.getCooldown(provider));
    }

    public void updateTime(@NotNull P provider) {
        this.cooldown.put(this.providerToKey.apply(provider), System.currentTimeMillis());
    }

    public void clear(@NotNull P provider) {
        this.clearCooldown(this.providerToKey.apply(provider));
    }

    public void clearCooldown(@NotNull K key) {
        this.cooldown.remove(key);
    }

    public boolean isCoolingDown(@NotNull P provider) {
        return this.getCooldown(provider) > 0L;
    }

    public long getDuration(@NotNull P provider) {
        return this.defaultDuration;
    }

    @NotNull
    public String formatSeconds(long cooldownMillis) {
        return this.numberFormatter.format((double)cooldownMillis / 1000.0);
    }

    public static NumberFormat createFormatter(@NotNull Consumer<NumberFormat> consumer) {
        NumberFormat format = NumberFormat.getInstance();
        consumer.accept(format);
        return format;
    }

    public static NumberFormat defaultFormatter() {
        return EasyCooldown.createFormatter(f -> f.setMaximumFractionDigits(2));
    }
}

