/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.easyplugin.utils;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SchedulerUtils {
    private final JavaPlugin plugin;

    public SchedulerUtils(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private JavaPlugin getPlugin() {
        return this.plugin;
    }

    public void run(Runnable runnable) {
        Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), runnable);
    }

    public void runAsync(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.getPlugin(), runnable);
    }

    public void runLater(long delay, Runnable runnable) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), runnable, delay);
    }

    public void runLaterAsync(long delay, Runnable runnable) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), runnable, delay);
    }

    public void runAtInterval(long interval, Runnable ... tasks) {
        this.runAtInterval(0L, interval, tasks);
    }

    public void runAtInterval(long delay, long interval, final Runnable ... tasks) {
        new BukkitRunnable(){
            private int index;

            public void run() {
                if (this.index >= tasks.length) {
                    this.cancel();
                    return;
                }
                tasks[this.index].run();
                ++this.index;
            }
        }.runTaskTimer((Plugin)this.getPlugin(), delay, interval);
    }

    public void runAtIntervalAsync(long interval, Runnable ... tasks) {
        this.runAtIntervalAsync(0L, interval, tasks);
    }

    public void runAtIntervalAsync(long delay, long interval, final Runnable ... tasks) {
        new BukkitRunnable(){
            private int index;

            public void run() {
                if (this.index >= tasks.length) {
                    this.cancel();
                    return;
                }
                tasks[this.index].run();
                ++this.index;
            }
        }.runTaskTimerAsynchronously((Plugin)this.getPlugin(), delay, interval);
    }

    public void repeat(final int repetitions, long interval, final Runnable task, final Runnable onComplete) {
        new BukkitRunnable(){
            private int index;

            public void run() {
                ++this.index;
                if (this.index >= repetitions) {
                    this.cancel();
                    if (onComplete == null) {
                        return;
                    }
                    onComplete.run();
                    return;
                }
                task.run();
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 0L, interval);
    }

    public void repeatAsync(final int repetitions, long interval, final Runnable task, final Runnable onComplete) {
        new BukkitRunnable(){
            private int index;

            public void run() {
                ++this.index;
                if (this.index >= repetitions) {
                    this.cancel();
                    if (onComplete == null) {
                        return;
                    }
                    onComplete.run();
                    return;
                }
                task.run();
            }
        }.runTaskTimerAsynchronously((Plugin)this.getPlugin(), 0L, interval);
    }

    public void repeatWhile(long interval, final Callable<Boolean> predicate, final Runnable task, final Runnable onComplete) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)predicate.call()).booleanValue()) {
                        this.cancel();
                        if (onComplete == null) {
                            return;
                        }
                        onComplete.run();
                        return;
                    }
                    task.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 0L, interval);
    }

    public void repeatWhileAsync(long interval, final Callable<Boolean> predicate, final Runnable task, final Runnable onComplete) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)predicate.call()).booleanValue()) {
                        this.cancel();
                        if (onComplete == null) {
                            return;
                        }
                        onComplete.run();
                        return;
                    }
                    task.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.getPlugin(), 0L, interval);
    }

    public class TaskBuilder {
        private final Queue<Task> taskList = new LinkedList<Task>();

        public TaskBuilder append(TaskBuilder builder) {
            this.taskList.addAll(builder.taskList);
            return this;
        }

        public TaskBuilder appendDelay(long delay) {
            this.taskList.add(onComplete -> SchedulerUtils.this.runLater(delay, onComplete));
            return this;
        }

        public TaskBuilder appendTask(Runnable task) {
            this.taskList.add(onComplete -> {
                task.run();
                onComplete.run();
            });
            return this;
        }

        public TaskBuilder appendTask(Task task) {
            this.taskList.add(task);
            return this;
        }

        public TaskBuilder appendDelayedTask(long delay, Runnable task) {
            this.taskList.add(onComplete -> SchedulerUtils.this.runLater(delay, () -> {
                task.run();
                onComplete.run();
            }));
            return this;
        }

        public TaskBuilder appendTasks(long delay, long interval, Runnable ... tasks) {
            this.taskList.add(onComplete -> {
                Runnable[] runnables = Arrays.copyOf(tasks, tasks.length + 1);
                runnables[runnables.length - 1] = onComplete;
                SchedulerUtils.this.runAtInterval(delay, interval, runnables);
            });
            return this;
        }

        public TaskBuilder appendRepeatingTask(int repetitions, long interval, Runnable task) {
            this.taskList.add(onComplete -> SchedulerUtils.this.repeat(repetitions, interval, task, onComplete));
            return this;
        }

        public TaskBuilder appendConditionalRepeatingTask(long interval, Callable<Boolean> predicate, Runnable task) {
            this.taskList.add(onComplete -> SchedulerUtils.this.repeatWhile(interval, predicate, task, onComplete));
            return this;
        }

        public TaskBuilder waitFor(final Callable<Boolean> predicate) {
            this.taskList.add(onComplete -> new BukkitRunnable(){

                public void run() {
                    try {
                        if (!((Boolean)predicate.call()).booleanValue()) {
                            return;
                        }
                        this.cancel();
                        onComplete.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.runTaskTimer((Plugin)SchedulerUtils.this.getPlugin(), 0L, 1L));
            return this;
        }

        public void runTasks() {
            this.startNext();
        }

        private void startNext() {
            Task task = this.taskList.poll();
            if (task == null) {
                return;
            }
            task.start(this::startNext);
        }
    }

    public static interface Task {
        public void start(Runnable var1);
    }
}

