/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.githubreleases4j;

import com.artformgames.plugin.residencelist.lib.githubreleases4j.GitHubHttpUtils;
import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubRelease;
import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubReleases4J;
import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubUser;
import com.artformgames.plugin.residencelist.lib.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubAsset {
    @NotNull
    private final GithubRelease source;
    @NotNull
    private final JSONObject contents;

    protected static GithubAsset of(@NotNull GithubRelease source, @NotNull JSONObject contents) {
        return new GithubAsset(source, contents);
    }

    private GithubAsset(@NotNull GithubRelease source, @NotNull JSONObject contents) {
        this.source = source;
        this.contents = contents;
    }

    @NotNull
    protected GithubRelease getSource() {
        return this.source;
    }

    @NotNull
    protected JSONObject getContents() {
        return this.contents;
    }

    public int getID() {
        return this.getContents().getInt("id");
    }

    @NotNull
    public String getURL() {
        return this.getContents().getString("url");
    }

    @NotNull
    public String getBrowserDownloadURL() {
        return this.getContents().getString("browser_download_url");
    }

    @NotNull
    public String getNodeID() {
        return this.getContents().getString("node_id");
    }

    @NotNull
    public String getName() {
        return this.getContents().getString("name");
    }

    @NotNull
    public String getLabel() {
        return this.getContents().getString("label");
    }

    @NotNull
    public String getState() {
        return this.getContents().getString("state");
    }

    @NotNull
    public String getContentType() {
        return this.getContents().getString("content_type");
    }

    public int getSize() {
        return this.getContents().getInt("size");
    }

    public int getDownloadCount() {
        return this.getContents().getInt("download_count");
    }

    @Nullable
    public Date getCreateTime() {
        return GithubReleases4J.parseDate(this.getContents().getString("created_at"));
    }

    @Nullable
    public Date getUpdateTime() {
        return GithubReleases4J.parseDate(this.getContents().getString("updated_at"));
    }

    public File download(CopyOption ... options) throws IOException {
        return GitHubHttpUtils.download(this.getBrowserDownloadURL(), this.getSource().getAuthToken(), this.getName(), options);
    }

    public File download(@NotNull String path, CopyOption ... options) throws IOException {
        return GitHubHttpUtils.download(this.getBrowserDownloadURL(), this.getSource().getAuthToken(), path, options);
    }

    public GithubUser getUploader() {
        return Optional.ofNullable(this.getContents().getJSONObject("uploader")).map(GithubUser::of).orElse(null);
    }

    public String toString() {
        return this.getContents().toString();
    }
}

