/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.githubreleases4j;

import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubAsset;
import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubReleases4J;
import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubUser;
import com.artformgames.plugin.residencelist.lib.json.JSONArray;
import com.artformgames.plugin.residencelist.lib.json.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GithubRelease {
    @NotNull
    public final String owner;
    @NotNull
    public final String repository;
    @Nullable
    protected String authToken;
    @NotNull
    private final JSONObject contents;

    @NotNull
    protected static GithubRelease of(@NotNull String owner, @NotNull String repository, @Nullable String token, @NotNull JSONObject contents) {
        return new GithubRelease(owner, repository, token, contents);
    }

    @NotNull
    protected static GithubRelease of(@NotNull String owner, @NotNull String repository, @NotNull JSONObject contents) {
        return GithubRelease.of(owner, repository, null, contents);
    }

    protected GithubRelease(@NotNull String owner, @NotNull String repository, @Nullable String authToken, @NotNull JSONObject contents) {
        this.owner = owner;
        this.repository = repository;
        this.authToken = authToken;
        this.contents = contents;
    }

    @NotNull
    protected JSONObject getContents() {
        return this.contents;
    }

    @NotNull
    public String getOwner() {
        return this.owner;
    }

    @NotNull
    public String getRepository() {
        return this.repository;
    }

    @Nullable
    protected String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(@Nullable String authToken) {
        this.authToken = authToken;
    }

    public int getID() {
        return this.getContents().getInt("id");
    }

    @NotNull
    public String getTagName() {
        return this.getContents().getString("tag_name");
    }

    @NotNull
    public String getName() {
        return this.getContents().getString("name");
    }

    @NotNull
    public String getBody() {
        return this.getContents().getString("body");
    }

    public boolean isDraft() {
        return this.getContents().getBoolean("draft");
    }

    public boolean isPrerelease() {
        return this.getContents().getBoolean("prerelease");
    }

    @Nullable
    public Date getCreateTime() {
        return GithubReleases4J.parseDate(this.getContents().getString("created_at"));
    }

    @Nullable
    public Date getPublishTime() {
        return GithubReleases4J.parseDate(this.getContents().getString("published_at"));
    }

    @NotNull
    public String getNodeID() {
        return this.getContents().getString("node_id");
    }

    @NotNull
    public String getTagCommitIsh() {
        return this.getContents().getString("target_commitish");
    }

    @NotNull
    public String getURL() {
        return this.getContents().getString("url");
    }

    @NotNull
    public String getHTMLUrl() {
        return this.getContents().getString("html_url");
    }

    @NotNull
    public String getAssetsURL() {
        return this.getContents().getString("assets_url");
    }

    @NotNull
    public String getUploadURL() {
        return this.getContents().getString("upload_url");
    }

    public String getTarballURL() {
        return this.getContents().getString("tarball_url");
    }

    public String getZipBallURL() {
        return this.getContents().getString("zipball_url");
    }

    @Nullable
    public String getDiscussionURL() {
        return this.getContents().getString("discussion_url");
    }

    @NotNull
    public GithubUser getAuthor() {
        return GithubUser.of(this.getContents().getJSONObject("author"));
    }

    @NotNull
    public List<GithubAsset> getAssets() {
        JSONArray assetsArray = this.getContents().getJSONArray("assets");
        if (assetsArray == null) {
            return new ArrayList<GithubAsset>();
        }
        return IntStream.range(0, assetsArray.length()).mapToObj(assetsArray::getJSONObject).map(assetsJSON -> GithubAsset.of(this, assetsJSON)).collect(Collectors.toList());
    }

    public String toString() {
        return this.getContents().toString();
    }
}

