/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data;

import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyCache;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyType;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifyConfig {
    @NotNull
    protected final NotifyCache<?, ?> cache;

    @Nullable
    public static NotifyConfig deserialize(@NotNull String config) {
        return Optional.ofNullable(NotifyCache.deserialize(config)).map(NotifyConfig::of).orElse(null);
    }

    @NotNull
    public static NotifyConfig of(@NotNull NotifyCache<?, ?> cache) {
        return new NotifyConfig(cache);
    }

    @Nullable
    public static NotifyConfig of(@NotNull String key, @Nullable String param, @Nullable String content) {
        return Optional.ofNullable(NotifyCache.of(key, param, content)).map(NotifyConfig::of).orElse(null);
    }

    public static <T extends NotifyType<M>, M> NotifyConfig of(@NotNull T type, @Nullable String param, @Nullable String content) {
        return NotifyConfig.of(type, type.parseMeta(param, content));
    }

    public static <T extends NotifyType<M>, M> NotifyConfig of(@NotNull T type, @Nullable M meta) {
        return NotifyConfig.of(NotifyCache.of(type, meta));
    }

    public NotifyConfig(@NotNull NotifyCache<?, ?> cache) {
        this.cache = cache;
    }

    @NotNull
    public NotifyCache<?, ?> getCache() {
        return this.cache;
    }

    public void execute(@NotNull Player player, @NotNull Map<String, Object> placeholders) {
        this.getCache().execute(player, placeholders);
    }

    public String serialize() {
        return this.getCache().serialize();
    }
}

