/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data;

import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundConfig {
    @NotNull
    protected String typeName;
    @Nullable
    protected Sound type;
    protected float volume;
    protected float pitch;

    public SoundConfig(@NotNull String typeName) {
        this(typeName, 1.0f, 1.0f);
    }

    public SoundConfig(@NotNull String typeName, float volume) {
        this(typeName, volume, 1.0f);
    }

    public SoundConfig(@NotNull String typeName, float volume, float pitch) {
        this(typeName, Arrays.stream(Sound.values()).filter(s -> s.name().equalsIgnoreCase(typeName)).findFirst().orElse(null), volume, pitch);
    }

    public SoundConfig(@NotNull String typeName, @Nullable Sound type, float volume, float pitch) {
        this.typeName = typeName;
        this.type = type;
        this.volume = volume;
        this.pitch = pitch;
    }

    public void playTo(@NotNull Player player) {
        this.playTo(player, player.getLocation());
    }

    public void playTo(@NotNull Player player, @NotNull Location location) {
        if (this.type == null) {
            return;
        }
        player.playSound(location, this.type, this.volume, this.pitch);
    }

    public void playAt(@NotNull Location location) {
        if (this.type == null) {
            return;
        }
        if (location.getWorld() == null) {
            return;
        }
        location.getWorld().playSound(location, this.type, this.volume, this.pitch);
    }

    public void playToAll() {
        Bukkit.getOnlinePlayers().forEach(this::playTo);
    }

    public void playToAll(@NotNull Location location) {
        Bukkit.getOnlinePlayers().forEach(player -> this.playTo((Player)player, location));
    }

    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Nullable
    public Sound getType() {
        return this.type;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setType(@NotNull Sound type) {
        this.typeName = type.name();
        this.type = type;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @NotNull
    public String serialize() {
        if (this.pitch != 1.0f) {
            return this.typeName + ":" + this.volume + ":" + this.pitch;
        }
        if (this.volume != 1.0f) {
            return this.typeName + ":" + this.volume;
        }
        return this.typeName;
    }

    @Contract(value="null -> null")
    @Nullable
    public static SoundConfig deserialize(@Nullable String string) throws Exception {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.contains(":")) {
            stringArray = string.split(":");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        String[] args = stringArray;
        if (args.length < 1) {
            return null;
        }
        try {
            return new SoundConfig(args[0], Sound.valueOf((String)args[0]), args.length >= 2 ? Float.parseFloat(args[1]) : 1.0f, args.length >= 3 ? Float.parseFloat(args[2]) : 1.0f);
        }
        catch (Exception exception) {
            throw new Exception("Sound " + string + " wasn't configured correctly.", exception);
        }
    }
}

