/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data;

import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.PreparedText;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.utils.MessageUtils;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredTitle;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class TitleConfig {
    @Nullable
    protected String line1;
    @Nullable
    protected String line2;
    protected @Range(from=0L, to=0x7FFFFFFFL) int fadeIn = 10;
    protected @Range(from=0L, to=0x7FFFFFFFL) int stay = 60;
    protected @Range(from=0L, to=0x7FFFFFFFL) int fadeOut = 10;

    @NotNull
    public static TitleConfig of(@Nullable String line1, @Nullable String line2) {
        return new TitleConfig(line1, line2);
    }

    @NotNull
    public static TitleConfig of(@Nullable String line1, @Nullable String line2, int fadeIn, int stay, int fadeOut) {
        return new TitleConfig(line1, line2, fadeIn, stay, fadeOut);
    }

    protected TitleConfig(@Nullable String line1, @Nullable String line2) {
        this.line1 = line1;
        this.line2 = line2;
    }

    protected TitleConfig(@Nullable String line1, @Nullable String line2, int fadeIn, int stay, int fadeOut) {
        this.line1 = line1;
        this.line2 = line2;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    public int stay() {
        return this.stay;
    }

    public void stay(int stay) {
        this.stay = stay;
    }

    @Nullable
    public String line1() {
        return this.line1;
    }

    public void line1(@Nullable String line1) {
        this.line1 = line1;
    }

    @Nullable
    public String line2() {
        return this.line2;
    }

    public void line2(@Nullable String line2) {
        this.line2 = line2;
    }

    public int fadeIn() {
        return this.fadeIn;
    }

    public void fadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    public int fadeOut() {
        return this.fadeOut;
    }

    public void fadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public boolean isStandardTime() {
        return this.fadeIn == 10 && this.stay == 60 && this.fadeOut == 10;
    }

    public void send(@NotNull Player player, @NotNull Map<String, Object> placeholders, @Nullable ConfiguredTitle.TitleConsumer sendConsumer) {
        this.send(player, this.fadeIn < 0 ? 10 : this.fadeIn, this.stay < 0 ? 60 : this.stay, this.fadeOut < 0 ? 10 : this.fadeOut, placeholders, sendConsumer);
    }

    public void send(@NotNull Player player, @Range(from=0L, to=0x7FFFFFFFL) int fadeIn, @Range(from=0L, to=0x7FFFFFFFL) int stay, @Range(from=0L, to=0x7FFFFFFFL) int fadeOut, @NotNull Map<String, Object> placeholders, @Nullable ConfiguredTitle.TitleConsumer sendConsumer) {
        if (this.line1 == null && this.line2 == null) {
            return;
        }
        if (sendConsumer == null) {
            return;
        }
        sendConsumer.send(player, fadeIn, stay, fadeOut, this.parseLine(player, this.line1, placeholders), this.parseLine(player, this.line2, placeholders));
    }

    @NotNull
    protected String parseLine(@NotNull Player player, @Nullable String text, @NotNull Map<String, Object> placeholders) {
        return text == null ? "" : MessageUtils.parseMessage((CommandSender)player, PreparedText.setPlaceholders(text, placeholders));
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.line1 != null) {
            map.put("line1", this.line1);
        }
        if (this.line2 != null) {
            map.put("line2", this.line2);
        }
        if (this.fadeIn > 0 && this.fadeIn != 10) {
            map.put("fadeIn", this.fadeIn);
        }
        if (this.stay > 0 && this.stay != 60) {
            map.put("stay", this.stay);
        }
        if (this.fadeOut > 0 && this.fadeOut != 10) {
            map.put("fadeOut", this.fadeOut);
        }
        return map;
    }

    @Nullable
    public static TitleConfig deserialize(@NotNull ConfigureSection section) {
        String line1 = section.getString("line1");
        String line2 = section.getString("line2");
        if (line1 == null && line2 == null) {
            return null;
        }
        return TitleConfig.of(line1, line2, section.getInt("fadeIn", -1), section.getInt("stay", -1), section.getInt("fadeOut", -1));
    }
}

