/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.source;

import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.source.BukkitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class BukkitSection
implements ConfigureSection {
    @NotNull
    protected final BukkitSource source;
    @Nullable
    protected final BukkitSection parent;
    @NotNull
    protected final String path;
    @NotNull
    protected final ConfigurationSection data;

    public BukkitSection(@NotNull BukkitSource source, @Nullable BukkitSection parent, @NotNull String path, @NotNull ConfigurationSection data) {
        this.source = source;
        this.parent = parent;
        this.path = path;
        this.data = data;
    }

    @NotNull
    public BukkitSource source() {
        return this.source;
    }

    @Override
    @Nullable
    public BukkitSection parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public String path() {
        return this.path;
    }

    @NotNull
    public ConfigurationSection data() {
        return this.data;
    }

    @Override
    @NotNull
    public Set<String> getKeys(boolean deep) {
        return this.data().getKeys(deep);
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<String, Object> getValues(boolean deep) {
        Map original = this.data().getValues(deep);
        for (Map.Entry entry : original.entrySet()) {
            if (!(entry.getValue() instanceof ConfigurationSection)) continue;
            original.put((String)entry.getKey(), this.createSection((String)entry.getKey(), (ConfigurationSection)entry.getValue()));
        }
        return Collections.unmodifiableMap(original);
    }

    public Map<String, Object> toMap(ConfigurationSection section) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (value instanceof ConfigurationSection) {
                map.put(key, this.toMap((ConfigurationSection)value));
                continue;
            }
            if (value instanceof BukkitSection) {
                map.put(key, this.toMap(((BukkitSection)value).data()));
                continue;
            }
            if (value instanceof List) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (Object o : (List)value) {
                    if (o instanceof ConfigurationSection) {
                        list.add(this.toMap((ConfigurationSection)o));
                        continue;
                    }
                    if (o instanceof BukkitSection) {
                        list.add(this.toMap(((BukkitSection)o).data()));
                        continue;
                    }
                    list.add((Map<String, Object>)o);
                }
                map.put(key, list);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<String, Object> asMap() {
        return this.toMap(this.data());
    }

    @Override
    public void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof BukkitSection) {
            value = ((BukkitSection)value).data();
        }
        this.data().set(path, value);
    }

    @Override
    public void remove(@NotNull String path) {
        this.data().set(path, null);
    }

    @Override
    @Nullable
    public ConfigureSection getSection(@NotNull String path) {
        Object value = this.get(path);
        if (value instanceof ConfigureSection) {
            return (ConfigureSection)value;
        }
        return null;
    }

    @NotNull
    public BukkitSection createSection(@NotNull String path, @NotNull ConfigurationSection section) {
        return new BukkitSection(this.source(), this, path, section);
    }

    @Override
    @NotNull
    public BukkitSection createSection(@NotNull String path, @NotNull Map<?, ?> data) {
        return this.createSection(path, this.data().createSection(path, data));
    }

    @Override
    @Nullable
    public Object get(@NotNull String path) {
        Object value = this.data().get(path);
        if (value instanceof ConfigurationSection) {
            return this.createSection(path, (ConfigurationSection)value);
        }
        return value;
    }
}

