/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.source;

import com.artformgames.plugin.residencelist.lib.configuration.commentable.Commentable;
import com.artformgames.plugin.residencelist.lib.configuration.commentable.CommentableOptions;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.file.FileConfigSource;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.source.BukkitSection;
import com.artformgames.plugin.residencelist.lib.yamlcommentupdater.CommentedSection;
import com.artformgames.plugin.residencelist.lib.yamlcommentupdater.CommentedYAMLWriter;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitSource
extends FileConfigSource<BukkitSection, YamlConfiguration, BukkitSource>
implements CommentedSection {
    @Nullable
    protected BukkitSection rootSection;

    public BukkitSource(@NotNull ConfigurationHolder<? extends BukkitSource> holder, @NotNull File file, @Nullable String resourcePath) {
        super(holder, System.currentTimeMillis(), file, resourcePath);
        this.initialize();
    }

    public void initialize() {
        try {
            this.initializeFile();
            this.onReload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    protected BukkitSource self() {
        return this;
    }

    @Override
    @NotNull
    public YamlConfiguration original() {
        return (YamlConfiguration)this.section().data();
    }

    @Override
    @NotNull
    public BukkitSection section() {
        return Objects.requireNonNull(this.rootSection, "Root section has not been initialized");
    }

    @Override
    public void save() throws Exception {
        CommentedYAMLWriter writer = new CommentedYAMLWriter(String.valueOf(this.pathSeparator()), 2, this.holder.options().get(CommentableOptions.COMMENT_EMPTY_VALUE));
        try {
            this.fileWriter(w -> w.write(writer.saveToString(this)));
        }
        catch (Exception ex) {
            this.fileWriter(w -> w.write(this.original().saveToString()));
        }
    }

    @Override
    protected void onReload() throws Exception {
        YamlConfiguration configuration = this.fileReader(YamlConfiguration::loadConfiguration);
        this.rootSection = new BukkitSection(this, null, "", (ConfigurationSection)configuration);
    }

    @Override
    public String serializeValue(@NotNull String key, @NotNull Object value) {
        YamlConfiguration temp = new YamlConfiguration();
        temp.set(key, value);
        return temp.saveToString();
    }

    @Override
    @Nullable
    public Set<String> getKeys(@Nullable String sectionKey, boolean deep) {
        if (sectionKey == null) {
            return this.section().getKeys(deep);
        }
        ConfigureSection sub = this.section().getSection(sectionKey);
        if (sub == null) {
            return null;
        }
        return sub.getKeys(deep);
    }

    @Override
    @Nullable
    public Object getValue(@NotNull String key) {
        return this.get(key);
    }

    @Override
    @Nullable
    public String getInlineComment(@NotNull String key) {
        return Commentable.getInlineComment(this.holder(), key);
    }

    @Override
    @Nullable
    public List<String> getHeaderComments(@Nullable String key) {
        return Commentable.getHeaderComments(this.holder(), key);
    }

    @Override
    @Nullable
    public List<String> getFooterComments(@Nullable String key) {
        return Commentable.getFooterComments(this.holder(), key);
    }
}

