/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.utils;

import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.utils.PlaceholderAPIHelper;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageUtils {
    private MessageUtils() {
    }

    @Contract(value="_,!null->!null")
    @Nullable
    public static String parseMessage(@Nullable CommandSender sender, @Nullable String message) {
        if (message == null) {
            return null;
        }
        if (sender instanceof Player && MessageUtils.hasPlaceholderAPI()) {
            message = PlaceholderAPIHelper.parseMessages((Player)sender, message);
        }
        return ColorParser.parse(message);
    }

    @NotNull
    public static List<String> parseMessage(@Nullable CommandSender sender, @NotNull List<String> messages) {
        if (sender instanceof Player && MessageUtils.hasPlaceholderAPI()) {
            messages = PlaceholderAPIHelper.parseMessages((Player)sender, messages);
        }
        return ColorParser.parse(messages);
    }

    public static boolean hasPlaceholderAPI() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }
}

