/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.AbstractConfigBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredValue;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.SoundConfig;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConfiguredSound
extends ConfiguredValue<SoundConfig> {
    public static final ValueType<SoundConfig> SOUND_TYPE = ValueType.of(SoundConfig.class);
    public static final ValueAdapter<SoundConfig> SOUND_ADAPTER = new ValueAdapter<SoundConfig>(SOUND_TYPE, (holder, type, value) -> value.serialize(), (holder, type, value) -> {
        String conf = holder.deserialize(String.class, value);
        return SoundConfig.deserialize(conf);
    });

    @NotNull
    public static Builder create() {
        return new Builder();
    }

    @NotNull
    public static ConfiguredSound of(Sound sound) {
        return ConfiguredSound.create().defaults(sound).build();
    }

    @NotNull
    public static ConfiguredSound of(Sound sound, float volume) {
        return ConfiguredSound.create().defaults(sound, volume).build();
    }

    @NotNull
    public static ConfiguredSound of(Sound sound, float volume, float pitch) {
        return ConfiguredSound.create().defaults(sound, volume, pitch).build();
    }

    @NotNull
    public static ConfiguredSound of(String soundName) {
        return ConfiguredSound.create().defaults(soundName).build();
    }

    @NotNull
    public static ConfiguredSound of(String soundName, float volume) {
        return ConfiguredSound.create().defaults(soundName, volume).build();
    }

    @NotNull
    public static ConfiguredSound of(String soundName, float volume, float pitch) {
        return ConfiguredSound.create().defaults(soundName, volume, pitch).build();
    }

    public ConfiguredSound(@NotNull ValueManifest<SoundConfig, SoundConfig> manifest, @NotNull ValueAdapter<SoundConfig> adapter) {
        super(manifest, adapter);
    }

    @Override
    public void set(@NotNull Sound sound) {
        this.set(sound, 1.0f);
    }

    public void set(@NotNull Sound sound, float volume) {
        this.set(sound, volume, 1.0f);
    }

    public void set(@NotNull Sound sound, float volume, float pitch) {
        this.set(new SoundConfig(sound.name(), sound, volume, pitch));
    }

    public void playTo(@NotNull Player player) {
        Optional.ofNullable((SoundConfig)this.get()).ifPresent(c -> c.playTo(player));
    }

    public void playToAll() {
        Optional.ofNullable((SoundConfig)this.get()).ifPresent(SoundConfig::playToAll);
    }

    public void playAt(Location location) {
        Optional.ofNullable((SoundConfig)this.get()).ifPresent(s -> s.playAt(location));
    }

    public static class Builder
    extends AbstractConfigBuilder<SoundConfig, SoundConfig, ConfiguredSound, ConfigurationHolder<?>, Builder> {
        @NotNull
        protected ValueAdapter<SoundConfig> adapter = SOUND_ADAPTER;

        protected Builder() {
            super(ConfigurationHolder.class, SOUND_TYPE);
        }

        @NotNull
        public Builder adapter(@NotNull ValueAdapter<SoundConfig> adapter) {
            this.adapter = adapter;
            return this;
        }

        @NotNull
        public Builder defaults(@NotNull Sound sound, float volume, float pitch) {
            return (Builder)this.defaults(new SoundConfig(sound.name(), sound, volume, pitch));
        }

        @NotNull
        public Builder defaults(@NotNull Sound sound, float volume) {
            return this.defaults(sound, volume, 1.0f);
        }

        @Override
        @NotNull
        public Builder defaults(@NotNull Sound sound) {
            return this.defaults(sound, 1.0f);
        }

        @NotNull
        public Builder defaults(@NotNull String soundName, float volume, float pitch) {
            return (Builder)this.defaults(new SoundConfig(soundName, volume, pitch));
        }

        @NotNull
        public Builder defaults(@NotNull String soundName, float volume) {
            return this.defaults(soundName, volume, 1.0f);
        }

        @Override
        @NotNull
        public Builder defaults(@NotNull String soundName) {
            return this.defaults(soundName, 1.0f);
        }

        @Override
        @NotNull
        protected Builder self() {
            return this;
        }

        @Override
        @NotNull
        public ConfiguredSound build() {
            return new ConfiguredSound(this.buildManifest(), this.adapter);
        }
    }
}

