/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.AbstractConfigBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredValue;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.TextParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.TitleConfig;
import com.artformgames.plugin.residencelist.lib.xseries.messages.Titles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ConfiguredTitle
extends ConfiguredValue<TitleConfig> {
    @NotNull
    public static final TitleConsumer DEFAULT_TITLE_CONSUMER = Titles::sendTitle;
    public static final ValueType<TitleConfig> TITLE_TYPE = ValueType.of(TitleConfig.class);
    public static final ValueAdapter<TitleConfig> TITLE_ADAPTER = new ValueAdapter<TitleConfig>(TITLE_TYPE, (holder, type, value) -> value.serialize(), (holder, type, value) -> {
        ConfigureSection section = holder.deserialize(ConfigureSection.class, value);
        return TitleConfig.deserialize(section);
    });
    @NotNull
    protected final TitleConsumer sendConsumer;
    @NotNull
    protected final UnaryOperator<String> paramBuilder;
    @NotNull
    protected final String[] params;

    public static Builder create() {
        return new Builder();
    }

    public static ConfiguredTitle of(@Nullable String line1, @Nullable String line2) {
        return ConfiguredTitle.create().defaults(line1, line2).build();
    }

    public static ConfiguredTitle of(@Nullable String line1, @Nullable String line2, int fadeIn, int stay, int fadeOut) {
        return ConfiguredTitle.create().defaults(line1, line2).fadeIn(fadeIn).stay(stay).fadeOut(fadeOut).build();
    }

    public ConfiguredTitle(@NotNull ValueManifest<TitleConfig, TitleConfig> manifest, ValueAdapter<TitleConfig> adapter, @NotNull UnaryOperator<String> paramBuilder, @NotNull String[] params, @NotNull TitleConsumer sendConsumer) {
        super(manifest, adapter);
        this.paramBuilder = paramBuilder;
        this.sendConsumer = sendConsumer;
        this.params = params;
    }

    @Override
    public void set(Consumer<TitleConfig> handler) {
        TitleConfig conf = (TitleConfig)this.get();
        handler.accept(conf);
        this.set(conf);
    }

    public void setLine1(@Nullable String line1) {
        this.set(conf -> conf.line1(line1));
    }

    public void setLine2(@Nullable String line2) {
        this.set(conf -> conf.line2(line2));
    }

    public void setFadeIn(int fadeIn) {
        this.set(conf -> conf.fadeIn(fadeIn));
    }

    public void setStay(int stay) {
        this.set(conf -> conf.stay(stay));
    }

    public void setFadeOut(int fadeOut) {
        this.set(conf -> conf.fadeOut(fadeOut));
    }

    public void send(@NotNull Player player, Object ... values) {
        this.send(player, this.params, values);
    }

    public void send(@NotNull Player player, @NotNull String[] params, @NotNull Object[] values) {
        this.send(player, TextParser.buildParams(this.paramBuilder, params, values));
    }

    public void send(@NotNull Player player, @NotNull Map<String, Object> placeholders) {
        TitleConfig config = (TitleConfig)this.get();
        if (config != null) {
            config.send(player, placeholders, this.sendConsumer);
        }
    }

    public void sendToAll(Object ... values) {
        this.sendToAll(this.params, values);
    }

    public void sendToAll(@NotNull String[] params, @NotNull Object[] values) {
        this.sendToAll(TextParser.buildParams(this.paramBuilder, params, values));
    }

    public void sendToAll(@NotNull Map<String, Object> placeholders) {
        TitleConfig config = (TitleConfig)this.get();
        if (config == null) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(onlinePlayer -> this.send((Player)onlinePlayer, placeholders));
    }

    public void sendToEach(@NotNull @NotNull Function<@NotNull Player, Object[]> eachValues) {
        this.sendToEach(null, eachValues);
    }

    public void sendToEach(@Nullable Predicate<Player> limiter, @NotNull @NotNull Function<@NotNull Player, Object[]> eachValues) {
        Predicate<Player> predicate = Optional.ofNullable(limiter).orElse(r -> true);
        Bukkit.getOnlinePlayers().stream().filter(predicate).forEach(r -> this.send((Player)r, (Object[])eachValues.apply((Player)r)));
    }

    public static class Builder
    extends AbstractConfigBuilder<TitleConfig, TitleConfig, ConfiguredTitle, ConfigurationHolder<?>, Builder> {
        @NotNull
        protected ValueAdapter<TitleConfig> adapter = TITLE_ADAPTER;
        @NotNull
        protected TitleConfig title = TitleConfig.of(null, null);
        @NotNull
        protected String[] params = new String[0];
        @NotNull
        protected TitleConsumer sendConsumer = DEFAULT_TITLE_CONSUMER;
        @NotNull
        protected UnaryOperator<String> paramFormatter = s -> "%(" + s + ")";

        protected Builder() {
            super(ConfigurationHolder.class, TITLE_TYPE);
            this.defaults(() -> this.title);
        }

        @NotNull
        public Builder adapter(@NotNull ValueAdapter<TitleConfig> adapter) {
            this.adapter = adapter;
            return this;
        }

        @Override
        @NotNull
        public Builder defaults(Consumer<TitleConfig> handler) {
            handler.accept(this.title);
            return this;
        }

        @NotNull
        public Builder defaults(@Nullable String line1, @Nullable String line2) {
            return this.line1(line1).line2(line2);
        }

        @NotNull
        public Builder line1(@Nullable String line1) {
            return this.defaults((TitleConfig t) -> t.line1(line1));
        }

        @NotNull
        public Builder line2(@Nullable String line2) {
            return this.defaults((TitleConfig t) -> t.line2(line2));
        }

        @NotNull
        public Builder fadeIn(@Range(from=0L, to=0x7FFFFFFFL) int fadeIn) {
            return this.defaults((TitleConfig t) -> t.fadeIn(fadeIn));
        }

        @NotNull
        public Builder stay(@Range(from=0L, to=0x7FFFFFFFL) int stay) {
            return this.defaults((TitleConfig t) -> t.stay(stay));
        }

        @NotNull
        public Builder fadeOut(@Range(from=0L, to=0x7FFFFFFFL) int fadeOut) {
            return this.defaults((TitleConfig t) -> t.fadeOut(fadeOut));
        }

        @NotNull
        public Builder params(String ... params) {
            this.params = params;
            return this;
        }

        @NotNull
        public Builder params(@NotNull List<String> params) {
            return this.params(params.toArray(new String[0]));
        }

        @NotNull
        public Builder whenSend(@NotNull TitleConsumer consumer) {
            this.sendConsumer = consumer;
            return this;
        }

        @Override
        @NotNull
        protected Builder self() {
            return this;
        }

        @Override
        @NotNull
        public ConfiguredTitle build() {
            return new ConfiguredTitle(this.buildManifest(), this.adapter, this.paramFormatter, this.params, this.sendConsumer);
        }
    }

    @FunctionalInterface
    public static interface TitleConsumer {
        public void send(@NotNull Player var1, @Range(from=0L, to=0x7FFFFFFFL) int var2, @Range(from=0L, to=0x7FFFFFFFL) int var3, @Range(from=0L, to=0x7FFFFFFFL) int var4, @NotNull String var5, @NotNull String var6);
    }
}

