/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.AbstractConfigBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.source.section.ConfigureSection;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredValue;
import com.artformgames.plugin.residencelist.lib.easyplugin.utils.ColorParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.PreparedItem;
import com.artformgames.plugin.residencelist.lib.xseries.XItemStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredItem
extends ConfiguredValue<ItemStack> {
    @NotNull
    public static final ValueType<ItemStack> ITEM_TYPE = ValueType.of(ItemStack.class);
    public static final ValueAdapter<ItemStack> ITEM_ADAPTER = new ValueAdapter<ItemStack>(ITEM_TYPE, (holder, type, value) -> XItemStack.serialize(value), (holder, type, value) -> {
        ConfigureSection section = (ConfigureSection)value;
        return XItemStack.deserialize(section.asMap());
    });
    @NotNull
    protected final BiFunction<Player, String, String> parser;
    @NotNull
    protected final String[] params;

    public static Builder create() {
        return new Builder();
    }

    public ConfiguredItem(@NotNull ValueManifest<ItemStack, ItemStack> manifest, ValueAdapter<ItemStack> adapter, @NotNull BiFunction<Player, String, String> parser, @NotNull String[] params) {
        super(manifest, adapter);
        this.parser = parser;
        this.params = params;
    }

    @Override
    public @NotNull Optional<@Nullable ItemStack> optional() {
        return Optional.ofNullable((ItemStack)super.get());
    }

    @Override
    @Nullable
    public ItemStack get() {
        return this.optional().map(ItemStack::clone).orElse(null);
    }

    @Nullable
    public ItemStack get(Consumer<ItemStack> modifier) {
        return this.optional().map(item -> {
            modifier.accept((ItemStack)item);
            return item;
        }).orElse(null);
    }

    @Nullable
    public ItemStack get(@Nullable Player player) {
        return this.get(player, new HashMap<String, Object>());
    }

    @Nullable
    public ItemStack get(@Nullable Player player, Object ... values) {
        return this.prepare(values).get(player);
    }

    @Nullable
    public ItemStack get(@Nullable Player player, @NotNull Map<String, Object> placeholders) {
        return ((PreparedItem)this.prepare(new Object[0]).placeholders(placeholders)).get(player);
    }

    @Nullable
    public Map<Integer, ItemStack> give(@NotNull Player player, Object ... values) {
        return this.prepare(values).give(player);
    }

    @NotNull
    public PreparedItem prepare(Object ... values) {
        return (PreparedItem)((PreparedItem)((PreparedItem)PreparedItem.of((Player player) -> this.get()).parser(this.parser)).params(this.params)).placeholders(values);
    }

    public void modifyItem(Consumer<ItemStack> modifier) {
        ItemStack item = this.get();
        if (item == null) {
            return;
        }
        modifier.accept(item);
        this.set(item);
    }

    public void modifyMeta(Consumer<ItemMeta> modifier) {
        this.modifyItem(item -> {
            ItemMeta meta = item.getItemMeta();
            modifier.accept(meta);
            item.setItemMeta(meta);
        });
    }

    public void setName(@Nullable String name) {
        this.modifyMeta(meta -> meta.setDisplayName(name));
    }

    public void setLore(@Nullable List<String> lore) {
        this.modifyMeta(meta -> meta.setLore(lore));
    }

    public void setLore(String ... lore) {
        if (lore.length == 0) {
            this.setLore((List<String>)null);
        } else {
            this.setLore(Arrays.asList(lore));
        }
    }

    public static class Builder
    extends AbstractConfigBuilder<ItemStack, ItemStack, ConfiguredItem, ConfigurationHolder<?>, Builder> {
        @Nullable
        protected ItemStack item = null;
        @NotNull
        protected String[] params = new String[0];
        @NotNull
        protected BiFunction<Player, String, String> parser = (player, message) -> ColorParser.parse(message);

        public Builder() {
            super(ConfigurationHolder.class, ITEM_TYPE);
            this.defaults(() -> this.item);
        }

        @Override
        @NotNull
        public Builder defaults(@Nullable ItemStack item) {
            this.item = item;
            return this;
        }

        @Override
        public Builder defaults(@NotNull Material type) {
            return this.defaults(new ItemStack(type));
        }

        @Override
        public Builder defaults(Consumer<ItemStack> consumer) {
            if (this.item == null) {
                return this.self();
            }
            consumer.accept(this.item);
            return this.self();
        }

        public Builder defaultMeta(Consumer<ItemMeta> consumer) {
            return this.defaults((ItemStack stack) -> {
                ItemMeta meta = stack.getItemMeta();
                consumer.accept(meta);
                stack.setItemMeta(meta);
            });
        }

        public Builder defaultType(@NotNull Material type) {
            return this.defaults(new ItemStack(type));
        }

        public Builder defaultName(@Nullable String name) {
            return this.defaultMeta(meta -> meta.setDisplayName(name));
        }

        public Builder defaultDataID(short dataID) {
            return this.defaults((ItemStack stack) -> stack.setDurability(dataID));
        }

        public Builder defaultLore(String ... lore) {
            return this.defaultLore(Arrays.asList(lore));
        }

        public Builder defaultLore(@NotNull List<String> lore) {
            return this.defaultMeta(meta -> meta.setLore(lore));
        }

        public Builder defaultEnchants(@NotNull Map<Enchantment, Integer> enchants) {
            return this.defaultMeta(meta -> enchants.forEach((enchant, level) -> meta.addEnchant(enchant, level.intValue(), true)));
        }

        public Builder defaultEnchant(@NotNull Enchantment enchant, int level) {
            return this.defaultEnchants(Collections.singletonMap(enchant, level));
        }

        public Builder defaultFlags(@NotNull Set<ItemFlag> flags) {
            return this.defaultMeta(meta -> flags.forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0})));
        }

        public Builder defaultFlags(ItemFlag ... flags) {
            return this.defaultFlags(new LinkedHashSet<ItemFlag>(Arrays.asList(flags)));
        }

        public Builder parser(@NotNull BiFunction<Player, String, String> parser) {
            this.parser = parser;
            return this.self();
        }

        public Builder params(String ... params) {
            this.params = params;
            return this.self();
        }

        public Builder params(@NotNull List<String> params) {
            this.params = params.toArray(new String[0]);
            return this.self();
        }

        @Override
        @NotNull
        protected Builder self() {
            return this;
        }

        @Override
        @NotNull
        public ConfiguredItem build() {
            return new ConfiguredItem(this.buildManifest(), ITEM_ADAPTER, this.parser, this.params);
        }
    }
}

