/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.data.TextContents;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.ContentHandler;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemModifier<S extends ItemModifier<S, R>, R>
extends ContentHandler<Player, S> {
    @NotNull
    protected final @NotNull Function<@NotNull Player, @Nullable ItemStack> itemProvider;
    @NotNull
    protected BiConsumer<ItemStack, Player> itemConsumer;
    @NotNull
    protected BiConsumer<ItemMeta, Player> metaConsumer;

    protected ItemModifier(@NotNull @NotNull Function<@NotNull Player, @Nullable ItemStack> itemProvider) {
        this.itemProvider = itemProvider;
        this.itemConsumer = (item, player) -> {};
        this.metaConsumer = (meta, player) -> {};
        this.lineSeparator = " ";
    }

    @Nullable
    public abstract R get(Player var1);

    public void applyTo(@Nullable ItemStack item, @Nullable Player player) {
        List<String> parsedLore;
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        String name = meta.getDisplayName();
        if (!name.isEmpty()) {
            meta.setDisplayName(this.parse(player, name));
        }
        if (!(parsedLore = this.parseLore(player, meta.getLore())).isEmpty()) {
            meta.setLore(parsedLore);
        }
        this.metaConsumer.accept(meta, player);
        item.setItemMeta(meta);
        this.itemConsumer.accept(item, player);
    }

    public S handleMeta(@NotNull BiConsumer<ItemMeta, Player> modifier) {
        this.metaConsumer = this.metaConsumer.andThen(modifier);
        return (S)((ItemModifier)this.self());
    }

    public S handleItem(@NotNull BiConsumer<ItemStack, Player> modifier) {
        this.itemConsumer = this.itemConsumer.andThen(modifier);
        return (S)((ItemModifier)this.self());
    }

    public S insert(@NotNull String key, @NotNull ConfiguredMessage<?> message, Object ... values) {
        return (S)((ItemModifier)this.insert(key, (T receiver) -> message.parse(receiver, values)));
    }

    public S amount(int amount) {
        return this.handleItem((item, player) -> item.setAmount(amount));
    }

    public S addEnchantment(Enchantment e) {
        return this.addEnchantment(e, 1);
    }

    public S addEnchantment(Enchantment e, int level) {
        return this.addEnchantment(e, level, true);
    }

    public S addEnchantment(Enchantment e, int level, boolean ignoreLevelRestriction) {
        return this.handleMeta((meta, player) -> meta.addEnchant(e, level, ignoreLevelRestriction));
    }

    public S addItemFlags(ItemFlag ... flags) {
        return this.handleMeta((meta, player) -> meta.addItemFlags(flags));
    }

    public S glow() {
        return ((ItemModifier)this.addItemFlags(ItemFlag.HIDE_ENCHANTS)).addEnchantment(Enchantment.DURABILITY);
    }

    @Deprecated
    public S setSkullOwner(String owner) {
        return this.handleMeta((meta, player) -> {
            if (!(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwner(owner);
        });
    }

    public S setSkullOwner(UUID owner) {
        return this.setSkullOwner(Bukkit.getOfflinePlayer((UUID)owner));
    }

    public S setSkullOwner(OfflinePlayer owner) {
        return this.handleMeta((meta, player) -> {
            if (!(meta instanceof SkullMeta)) {
                return;
            }
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwningPlayer(owner);
        });
    }

    public List<String> parseLore(@Nullable Player player, @Nullable List<String> current) {
        if (current == null || current.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> parsed = new ArrayList<String>();
        this.handle(TextContents.of(current, new HashMap<String, List<String>>()), player, parsed::add);
        return parsed;
    }
}

