/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item;

import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ItemModifier;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreparedItem
extends ItemModifier<PreparedItem, ItemStack> {
    public static PreparedItem of(@NotNull @NotNull Function<@NotNull Player, @Nullable ItemStack> itemProvider) {
        return new PreparedItem(itemProvider);
    }

    public static PreparedItem of(@Nullable ItemStack item) {
        return PreparedItem.of((Player player) -> item);
    }

    public PreparedItem(@NotNull @NotNull Function<@NotNull Player, @Nullable ItemStack> itemProvider) {
        super(itemProvider);
    }

    @Override
    @Nullable
    public ItemStack get(@Nullable Player player) {
        @Nullable ItemStack item = (ItemStack)this.itemProvider.apply(player);
        if (item == null) {
            return null;
        }
        this.applyTo(item, player);
        return item;
    }

    @Nullable
    public Map<Integer, ItemStack> give(Player player) {
        @Nullable ItemStack item = this.get(player);
        if (item == null) {
            return null;
        }
        return player.getInventory().addItem(new ItemStack[]{item});
    }

    public boolean giveOrDrop(Player player) {
        @Nullable Map<Integer, ItemStack> left = this.give(player);
        if (left == null) {
            return false;
        }
        left.values().forEach(item -> player.getWorld().dropItem(player.getLocation(), item));
        return true;
    }

    @Override
    public PreparedItem self() {
        return this;
    }
}

