/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify;

import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueAdapter;
import com.artformgames.plugin.residencelist.lib.configuration.adapter.ValueType;
import com.artformgames.plugin.residencelist.lib.configuration.builder.AbstractConfigBuilder;
import com.artformgames.plugin.residencelist.lib.configuration.source.ConfigurationHolder;
import com.artformgames.plugin.residencelist.lib.configuration.value.ValueManifest;
import com.artformgames.plugin.residencelist.lib.configuration.value.standard.ConfiguredList;
import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.TextParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.NotifyConfig;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.SoundConfig;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.TitleConfig;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.PreparedNotify;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class ConfiguredNotify
extends ConfiguredList<NotifyConfig> {
    public static final ValueType<NotifyConfig> NOTIFY_TYPE = ValueType.of(NotifyConfig.class);
    public static final ValueAdapter<NotifyConfig> NOTIFY_ADAPTER = new ValueAdapter<NotifyConfig>(NOTIFY_TYPE, (holder, type, value) -> value.serialize(), (holder, type, value) -> {
        String conf = holder.deserialize(String.class, value);
        return NotifyConfig.deserialize(conf);
    });
    @NotNull
    protected final UnaryOperator<String> paramBuilder;
    @NotNull
    protected final String[] params;

    public static NotifyBuilder create() {
        return new NotifyBuilder();
    }

    public ConfiguredNotify(@NotNull ValueManifest<List<NotifyConfig>, NotifyConfig> manifest, @NotNull ValueAdapter<NotifyConfig> adapter, @NotNull UnaryOperator<String> paramBuilder, @NotNull String[] params) {
        super(manifest, ArrayList::new, adapter);
        this.paramBuilder = paramBuilder;
        this.params = params;
    }

    @NotNull
    public PreparedNotify prepare(Object ... values) {
        return new PreparedNotify((List)this.getNotNull(), TextParser.buildParams(this.paramBuilder, this.params, values));
    }

    public void send(@NotNull Player player, Object ... values) {
        this.prepare(values).to(player);
    }

    public void send(@NotNull Iterable<? extends Player> players, Object ... values) {
        this.prepare(values).to(players);
    }

    public void sendAll(Object ... values) {
        this.prepare(values).toAll();
    }

    public static class NotifyBuilder
    extends AbstractConfigBuilder<List<NotifyConfig>, NotifyConfig, ConfiguredNotify, ConfigurationHolder<?>, NotifyBuilder> {
        @NotNull
        protected final List<NotifyConfig> notifications = new ArrayList<NotifyConfig>();
        @NotNull
        protected String[] params = new String[0];
        @NotNull
        protected ValueAdapter<NotifyConfig> adapter = NOTIFY_ADAPTER;
        @NotNull
        protected UnaryOperator<String> paramFormatter = s -> "%(" + s + ")";

        protected NotifyBuilder() {
            super(ConfigurationHolder.class, new ValueType<List<NotifyConfig>>(){});
        }

        @Override
        @NotNull
        protected NotifyBuilder self() {
            return this;
        }

        @Override
        @NotNull
        public ConfiguredNotify build() {
            return new ConfiguredNotify(this.buildManifest(), this.adapter, this.paramFormatter, this.params);
        }

        public NotifyBuilder adapter(@NotNull ValueAdapter<NotifyConfig> adapter) {
            this.adapter = adapter;
            return this;
        }

        public NotifyBuilder defaultMessages(String ... messages) {
            return this.defaultMessages(Arrays.asList(messages));
        }

        public NotifyBuilder defaultMessages(@NotNull List<String> messages) {
            for (String message : messages) {
                this.notifications.add(NotifyConfig.of(NotifyType.Standard.MESSAGE, message));
            }
            return (NotifyBuilder)this.defaults(this.notifications);
        }

        public NotifyBuilder defaultActionBar(@NotNull String message) {
            this.notifications.add(NotifyConfig.of(NotifyType.Standard.ACTIONBAR, message));
            return (NotifyBuilder)this.defaults(this.notifications);
        }

        public NotifyBuilder defaultSound(@NotNull Sound sound, float volume, float pitch) {
            return this.defaultSound(sound.name(), volume, pitch);
        }

        public NotifyBuilder defaultSound(@NotNull Sound sound, float volume) {
            return this.defaultSound(sound, volume, 1.0f);
        }

        public NotifyBuilder defaultSound(@NotNull Sound sound) {
            return this.defaultSound(sound, 1.0f);
        }

        public NotifyBuilder defaultSound(@NotNull String soundName, float volume, float pitch) {
            this.notifications.add(NotifyConfig.of(NotifyType.Standard.SOUND, new SoundConfig(soundName, volume, pitch)));
            return (NotifyBuilder)this.defaults(this.notifications);
        }

        public NotifyBuilder defaultSound(@NotNull String soundName, float volume) {
            return this.defaultSound(soundName, volume, 1.0f);
        }

        public NotifyBuilder defaultSound(@NotNull String soundName) {
            return this.defaultSound(soundName, 1.0f);
        }

        public NotifyBuilder defaultTitle(@Nullable String line1, @Nullable String line2, @Range(from=0L, to=0x7FFFFFFFL) int fadeIn, @Range(from=0L, to=0x7FFFFFFFL) int stay, @Range(from=0L, to=0x7FFFFFFFL) int fadeOut) {
            this.notifications.add(NotifyConfig.of(NotifyType.Standard.TITLE, TitleConfig.of(line1, line2, fadeIn, stay, fadeOut)));
            return (NotifyBuilder)this.defaults(this.notifications);
        }

        public NotifyBuilder defaultTitle(@Nullable String line1, @Nullable String line2) {
            return this.defaultTitle(line1, line2, 10, 60, 10);
        }

        public NotifyBuilder params(String ... params) {
            this.params = params;
            return this;
        }

        public NotifyBuilder params(@NotNull List<String> params) {
            return this.params(params.toArray(new String[0]));
        }

        public NotifyBuilder formatParam(UnaryOperator<String> paramFormatter) {
            this.paramFormatter = paramFormatter;
            return this;
        }
    }
}

