/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type;

import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifyCache<T extends NotifyType<M>, M> {
    @NotNull
    public static final Pattern CONFIG_FORMAT = Pattern.compile("\\[(?<type>[^@\\]]+)(@(?<param>[^]]+))?] (?<content>.*)");
    @NotNull
    protected final T type;
    @Nullable
    protected final M meta;

    @Nullable
    public static NotifyCache<?, ?> deserialize(@NotNull String config) {
        Matcher matcher = CONFIG_FORMAT.matcher(config.trim());
        if (!matcher.matches()) {
            return NotifyCache.of("MESSAGE", null, config);
        }
        return NotifyCache.of(matcher.group("type"), matcher.group("param"), matcher.group("content"));
    }

    @Nullable
    public static NotifyCache<?, ?> of(@NotNull String key, @Nullable String param, @Nullable String content) {
        NotifyType<?> type = NotifyType.get(key);
        if (type == null) {
            return null;
        }
        return NotifyCache.of(type, param, content);
    }

    public static <T extends NotifyType<M>, M> NotifyCache<T, M> of(@NotNull T type, @Nullable String param, @Nullable String content) {
        return new NotifyCache<T, M>(type, type.parseMeta(param, content));
    }

    public static <T extends NotifyType<M>, M> NotifyCache<T, M> of(@NotNull T type, @Nullable M meta) {
        return new NotifyCache<T, M>(type, meta);
    }

    public NotifyCache(@NotNull T type, @Nullable M meta) {
        this.type = type;
        this.meta = meta;
    }

    @NotNull
    public T getType() {
        return this.type;
    }

    @Nullable
    public M getMeta() {
        return this.meta;
    }

    public void execute(@NotNull Player player, @NotNull Map<String, Object> placeholders) {
        ((NotifyType)this.type).execute(player, this.meta, placeholders);
    }

    public String serialize() {
        return ((NotifyType)this.type).serializeConfig(this.meta);
    }
}

