/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type;

import com.artformgames.plugin.residencelist.lib.configuration.value.text.function.TextParser;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.utils.MessageUtils;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.standard.SoundNotify;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.standard.StringNotify;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.standard.TitleNotify;
import com.artformgames.plugin.residencelist.lib.xseries.messages.ActionBar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NotifyType<M> {
    public static final Set<NotifyType<?>> TYPES = new HashSet(Arrays.asList(Standard.values()));
    @NotNull
    protected final String key;
    @NotNull
    protected final Class<M> metaClass;

    public static NotifyType<?> get(@NotNull String key) {
        return TYPES.stream().filter(type -> type.key.equalsIgnoreCase(key)).findFirst().orElse(null);
    }

    protected NotifyType(@NotNull String key, @NotNull Class<M> metaClass) {
        this.key = key;
        this.metaClass = metaClass;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public Class<M> getMetaClass() {
        return this.metaClass;
    }

    @Nullable
    public abstract M parseMeta(@Nullable String var1, @Nullable String var2);

    @NotNull
    public abstract String serializeConfig(@Nullable M var1);

    public abstract void execute(@NotNull Player var1, @Nullable M var2, @NotNull Map<String, Object> var3);

    @Contract(value="_, _, null -> null; _, _, !null -> !null")
    protected String setPlaceholders(@NotNull Player player, @NotNull Map<String, Object> placeholders, @Nullable String content) {
        if (content == null) {
            return null;
        }
        return MessageUtils.parseMessage((CommandSender)player, TextParser.setPlaceholders(content, placeholders));
    }

    public static interface Standard {
        public static final StringNotify MESSAGE = StringNotify.of("MESSAGE", CommandSender::sendMessage, content -> Optional.ofNullable(content).orElse(" "));
        public static final StringNotify MSG = StringNotify.of("MSG", CommandSender::sendMessage);
        public static final StringNotify ACTIONBAR = StringNotify.of("ACTIONBAR", ActionBar::sendActionBar);
        public static final TitleNotify TITLE = new TitleNotify("TITLE");
        public static final SoundNotify SOUND = new SoundNotify("SOUND");

        public static NotifyType<?>[] values() {
            return new NotifyType[]{MESSAGE, MSG, ACTIONBAR, TITLE, SOUND};
        }

        public static NotifyType<?> valueOf(String name) {
            return Arrays.stream(Standard.values()).filter(type -> type.key.equalsIgnoreCase(name)).findFirst().orElse(null);
        }
    }
}

