/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.standard;

import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyType;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringNotify
extends NotifyType<String> {
    public static StringNotify of(String key, BiConsumer<Player, String> consumer) {
        return StringNotify.of(key, consumer, content -> "[" + key + "] " + (content == null ? " " : content));
    }

    public static StringNotify of(String key, final BiConsumer<Player, String> consumer, final UnaryOperator<String> serializer) {
        return new StringNotify(key){

            @Override
            @NotNull
            public String serializeConfig(@Nullable String meta) {
                return (String)serializer.apply(meta);
            }

            @Override
            public void send(@NotNull Player player, @NotNull String parsedContent) {
                consumer.accept(player, parsedContent);
            }
        };
    }

    protected StringNotify(String key) {
        super(key, String.class);
    }

    public abstract void send(@NotNull Player var1, @NotNull String var2);

    @Override
    @Nullable
    public String parseMeta(@Nullable String param, @Nullable String content) {
        return content;
    }

    @Override
    public void execute(@NotNull Player player, @Nullable String content, @NotNull Map<String, Object> placeholders) {
        if (content == null) {
            return;
        }
        this.send(player, this.setPlaceholders(player, placeholders, content));
    }
}

