/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.standard;

import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.data.TitleConfig;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.notify.type.NotifyType;
import com.artformgames.plugin.residencelist.lib.xseries.messages.Titles;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleNotify
extends NotifyType<TitleConfig> {
    public static final Pattern PARAM_FORMAT = Pattern.compile("(?<fadeIn>\\d+),(?<stay>\\d+),(?<fadeOut>\\d+)");

    public TitleNotify(String key) {
        super(key, TitleConfig.class);
    }

    @Override
    @Nullable
    public TitleConfig parseMeta(@Nullable String param, @Nullable String content) {
        String line2;
        if (content == null) {
            return null;
        }
        String[] lines = content.split("\\{n}");
        if (lines.length == 0) {
            return null;
        }
        String line1 = lines[0];
        String string = line2 = lines.length > 1 ? lines[1] : null;
        if (param == null) {
            return TitleConfig.of(line1, line2);
        }
        Matcher paramMatcher = PARAM_FORMAT.matcher(param);
        if (!paramMatcher.matches()) {
            return TitleConfig.of(line1, line2);
        }
        return TitleConfig.of(line1, line2, Integer.parseInt(paramMatcher.group("fadeIn")), Integer.parseInt(paramMatcher.group("stay")), Integer.parseInt(paramMatcher.group("fadeOut")));
    }

    @Override
    @NotNull
    public String serializeConfig(@Nullable TitleConfig meta) {
        String line2;
        if (meta == null || meta.line1() == null && meta.line2() == null) {
            return "[" + this.key + "] ";
        }
        String line1 = meta.line1() == null ? "" : meta.line1();
        String string = line2 = meta.line2() == null ? "" : meta.line2();
        if (meta.isStandardTime()) {
            return "[" + this.key + "] " + line1 + "{n}" + line2;
        }
        return "[" + this.key + "@" + meta.fadeIn() + "," + meta.stay() + "," + meta.fadeOut() + "] " + line1 + "{n}" + line2;
    }

    @Override
    public void execute(@NotNull Player player, @Nullable TitleConfig meta, @NotNull Map<String, Object> placeholders) {
        if (meta != null) {
            meta.send(player, placeholders, Titles::sendTitle);
        }
    }
}

