/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.xseries.profiles.gameprofile;

import com.artformgames.plugin.residencelist.lib.xseries.profiles.gameprofile.MojangGameProfile;
import com.artformgames.plugin.residencelist.lib.xseries.profiles.gameprofile.NewGameProfile;
import com.artformgames.plugin.residencelist.lib.xseries.profiles.gameprofile.OldGameProfile;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.XReflection;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class XGameProfile {
    private static final boolean USE_RECORDS = XReflection.isRecord(GameProfile.class);

    private XGameProfile() {
    }

    public static @Nullable MojangGameProfile of(GameProfile gameProfile) {
        if (gameProfile == null) {
            return null;
        }
        if (USE_RECORDS) {
            return new NewGameProfile(gameProfile);
        }
        return new OldGameProfile(gameProfile);
    }

    public static MojangGameProfile create(UUID id, String name, PropertyMap properties) {
        if (USE_RECORDS) {
            return XGameProfile.of(new GameProfile(id, name, properties));
        }
        GameProfile gameProfile = new GameProfile(id, name);
        MojangGameProfile converted = XGameProfile.of(gameProfile);
        converted.properties().putAll((Multimap)properties);
        return converted;
    }

    public static MojangGameProfile create(UUID id, String name) {
        return XGameProfile.of(new GameProfile(id, name));
    }
}

