/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.xseries.profiles.objects.cache;

import com.artformgames.plugin.residencelist.lib.xseries.profiles.objects.cache.CacheableProfileable;
import java.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class TimedCacheableProfileable
extends CacheableProfileable {
    private long lastUpdate;

    @NotNull
    protected Duration expiresAfter() {
        return Duration.ofHours(6L);
    }

    @Override
    public final boolean hasExpired(boolean renew) {
        Duration expiresAfter = this.expiresAfter();
        if (expiresAfter.isZero()) {
            return false;
        }
        if (super.hasExpired(renew)) {
            return true;
        }
        if (this.cache == null && this.lastError == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.lastUpdate == 0L) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        long diff = now - this.lastUpdate;
        if (diff >= expiresAfter.toMillis()) {
            if (renew) {
                this.lastUpdate = now;
            }
            return true;
        }
        return false;
    }
}

