/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm;

import com.artformgames.plugin.residencelist.lib.xseries.reflection.ReflectiveHandle;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.XAccessFlag;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.XReflection;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.classes.ClassHandle;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.objects.ReflectedObject;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.objects.ReflectedObjectHandle;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.minecraft.MinecraftMapping;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MethodMemberHandle
extends FlaggedNamedMemberHandle {
    protected ClassHandle[] parameterTypes = new ClassHandle[0];

    public MethodMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    public MethodMemberHandle parameters(ClassHandle ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    @Override
    public MethodMemberHandle returns(Class<?> clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle returns(ClassHandle clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle asStatic() {
        super.asStatic();
        return this;
    }

    public MethodMemberHandle parameters(Class<?> ... parameterTypes) {
        this.parameterTypes = (ClassHandle[])Arrays.stream(parameterTypes).map(XReflection::of).toArray(ClassHandle[]::new);
        return this;
    }

    @Override
    public MethodMemberHandle signature(@Language(value="Java", suffix=";") String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseMethod(this);
    }

    @Override
    public MethodMemberHandle map(MinecraftMapping mapping, @Pattern(value="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String name) {
        super.map(mapping, name);
        return this;
    }

    @Override
    public MethodMemberHandle named(String ... names) {
        super.named(names);
        return this;
    }

    public MethodType getMethodType() {
        return MethodType.methodType(this.getReturnType(), FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes));
    }

    @ApiStatus.Experimental
    public CallSite toLambda(Class<?> proxy, String interfaceMethod) throws ReflectiveOperationException, LambdaConversionException {
        MethodType factoryType = this.getMethodType();
        MethodType implType = this.accessFlags.contains((Object)XAccessFlag.STATIC) ? MethodType.methodType(proxy) : MethodType.methodType(proxy, (Class)this.clazz.reflect());
        return LambdaMetafactory.metafactory(this.clazz.getNamespace().getLookup(), interfaceMethod, implType, factoryType, this.reflect(), factoryType);
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        return this.clazz.getNamespace().getLookup().unreflect(this.reflectJvm());
    }

    @Override
    @NotNull
    public ReflectiveHandle<ReflectedObject> jvm() {
        return new ReflectedObjectHandle(() -> ReflectedObject.of(this.reflectJvm()));
    }

    public Method reflectJvm() throws ReflectiveOperationException {
        Objects.requireNonNull(this.returnType, "Return type not specified");
        if (this.names.isEmpty()) {
            throw new IllegalStateException("No names specified");
        }
        Throwable errors = null;
        Method method = null;
        Class clazz = (Class)this.clazz.reflect();
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        Class<?> returnType = this.getReturnType();
        for (String name : this.names) {
            if (method != null) break;
            try {
                method = clazz.getDeclaredMethod(name, parameterTypes);
                if (method.getReturnType() == returnType) continue;
                throw new NoSuchMethodException("Method named '" + name + "' was found but the return types don't match: " + this.returnType + " != " + method.getReturnType());
            }
            catch (NoSuchMethodException ignored) {
                try {
                    method = clazz.getMethod(name, parameterTypes);
                    if (method.getReturnType() == returnType) continue;
                    throw new NoSuchMethodException("Method named '" + name + "' was found but the return types don't match: " + this.returnType + " != " + method.getReturnType());
                }
                catch (NoSuchMethodException ex2) {
                    NoSuchMethodException realEx = ex2;
                    method = null;
                    if (errors == null) {
                        errors = new NoSuchMethodException("None of the methods were found for " + this);
                    }
                    errors.addSuppressed(realEx);
                }
            }
        }
        if (method == null) {
            throw (NoSuchMethodException)XReflection.relativizeSuppressedExceptions(errors);
        }
        return this.handleAccessible(method);
    }

    @Override
    public MethodMemberHandle copy() {
        MethodMemberHandle handle = new MethodMemberHandle(this.clazz);
        handle.returnType = this.returnType;
        handle.parameterTypes = this.parameterTypes;
        handle.accessFlags.addAll(this.accessFlags);
        handle.names.addAll(this.names);
        return handle;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        str = str + this.accessFlags.stream().map(x -> x.name().toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
        if (this.returnType != null) {
            str = str + this.returnType + " ";
        }
        str = str + String.join((CharSequence)"/", this.names);
        str = str + '(' + Arrays.stream(this.parameterTypes).map(Object::toString).collect(Collectors.joining(", ")) + ')';
        return str + '}';
    }
}

