/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.classes;

import com.artformgames.plugin.residencelist.lib.xseries.reflection.ReflectiveNamespace;
import com.artformgames.plugin.residencelist.lib.xseries.reflection.jvm.classes.ClassHandle;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StaticClassHandle
extends ClassHandle {
    @NotNull
    protected Class<?> clazz;

    public StaticClassHandle(ReflectiveNamespace namespace, @NotNull Class<?> clazz) {
        super(namespace);
        this.clazz = Objects.requireNonNull(clazz);
    }

    private Class<?> purifyClass() {
        Class<?> component;
        Class<?> pureClazz = this.clazz;
        while ((component = pureClazz.getComponentType()) != null) {
            pureClazz = component;
        }
        return Objects.requireNonNull(pureClazz);
    }

    @Override
    public StaticClassHandle asArray(int dimension) {
        Class<?> arrayClass = this.purifyClass();
        if (dimension > 0) {
            for (int i = 0; i < dimension; ++i) {
                arrayClass = Array.newInstance(arrayClass, 0).getClass();
            }
        }
        this.clazz = arrayClass;
        return this;
    }

    @Override
    public Class<?> reflect() throws ClassNotFoundException {
        return this.checkConstraints(this.clazz);
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    @Override
    public Set<String> getPossibleNames() {
        return Collections.singleton(this.clazz.getSimpleName());
    }

    @Override
    public StaticClassHandle copy() {
        return new StaticClassHandle(this.namespace, this.clazz);
    }

    public String toString() {
        return "StaticClassHandle(" + this.clazz + ')';
    }
}

