/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.storage;

import com.artformgames.plugin.residencelist.api.ResidenceManager;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.lib.easyplugin.user.UserDataRegistry;
import com.artformgames.plugin.residencelist.storage.DataStorage;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CombinedStorage<U extends UserListData, D extends ResidenceData>
implements DataStorage<U, D> {
    @NotNull
    protected final UserDataRegistry<UUID, U> userManager;
    @NotNull
    protected final ResidenceManager<D> residenceManager;

    protected CombinedStorage(@NotNull UserDataRegistry<UUID, U> userManager, @NotNull ResidenceManager<D> residenceManager) {
        this.userManager = userManager;
        this.residenceManager = residenceManager;
    }

    @Override
    public abstract void initialize();

    @Override
    public abstract void shutdown();

    @Override
    public @Unmodifiable @NotNull Set<D> listResidences() {
        return this.residenceManager.listResidences();
    }

    @Override
    @Nullable
    public D getResidence(@NotNull String name) {
        return this.residenceManager.getResidence(name);
    }

    @Override
    @NotNull
    public D loadResidence(String residenceName) throws Exception {
        return this.residenceManager.loadResidence(residenceName);
    }

    @Override
    public void renameResidence(String oldName, String newName) {
        this.residenceManager.renameResidence(oldName, newName);
    }

    @Override
    public void removeResidence(@NotNull String name) {
        this.residenceManager.removeResidence(name);
    }

    @Override
    public boolean updateResidence(@NotNull ResidenceData data, @NotNull Consumer<ResidenceData> dataConsumer) {
        return this.residenceManager.updateResidence(data, dataConsumer);
    }

    @Override
    public void saveAllResidences() {
        this.residenceManager.saveAllResidences();
    }
}

