/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.storage.yaml;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.sort.SortFunctions;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.lib.easyplugin.EasyPlugin;
import com.artformgames.plugin.residencelist.lib.easyplugin.user.UserDataManager;
import com.artformgames.plugin.residencelist.storage.DataStorage;
import com.artformgames.plugin.residencelist.storage.yaml.data.YAMLResidenceData;
import com.artformgames.plugin.residencelist.storage.yaml.data.YAMLUserData;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class YAMLStorage
extends UserDataManager<UUID, YAMLUserData>
implements DataStorage<YAMLUserData, YAMLResidenceData> {
    public static final String USER_DATA_FOLDER = "users";
    public static final String RESIDENCE_DATA_FOLDER = "residences";
    @NotNull
    protected final File userDataFolder;
    @NotNull
    protected final File residenceDataFolder;
    protected Map<String, YAMLResidenceData> residences = new HashMap<String, YAMLResidenceData>();

    public YAMLStorage(@NotNull EasyPlugin plugin) {
        super(plugin);
        this.residenceDataFolder = this.initializeFolder(plugin.getDataFolder(), RESIDENCE_DATA_FOLDER);
        this.userDataFolder = this.initializeFolder(plugin.getDataFolder(), USER_DATA_FOLDER);
    }

    @Override
    public void initialize() {
        int loaded = this.loadAllResidences();
        this.plugin.log("Successfully loaded " + loaded + " residence data.");
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            this.plugin.log("Load online users' data...");
            this.loadOnline(OfflinePlayer::getUniqueId);
        }
    }

    @Override
    public void shutdown() {
        this.saveAll();
        this.saveAllResidences();
        super.shutdown();
    }

    @Override
    @NotNull
    public Map<UUID, YAMLUserData> cache() {
        return this.dataCache;
    }

    protected File initializeFolder(File parent, String folderName) {
        File folder = new File(parent, folderName);
        if (!folder.exists()) {
            folder.mkdirs();
        } else if (!folder.isDirectory()) {
            folder.delete();
            folder.mkdirs();
        }
        return folder;
    }

    @Override
    @NotNull
    public YAMLUserData emptyUser(@NotNull UUID key) {
        return new YAMLUserData(key, new ArrayList<String>(), SortFunctions.NAME, false);
    }

    @Override
    @Nullable
    protected YAMLUserData loadData(@NotNull UUID key) {
        File userFile = new File(this.userDataFolder, key + ".yaml");
        if (!userFile.exists()) {
            return null;
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)userFile);
        return new YAMLUserData(key, new ArrayList<String>(conf.getStringList("pinned")), SortFunctions.parse(conf.getInt("sort", 0)), conf.getBoolean("reversed", false));
    }

    @Override
    protected void saveData(@NotNull YAMLUserData data) throws Exception {
        File userFile = new File(this.userDataFolder, data.key() + ".yaml");
        if (data.isEmpty() && userFile.exists()) {
            userFile.delete();
            return;
        }
        YamlConfiguration conf = userFile.exists() ? YamlConfiguration.loadConfiguration((File)userFile) : new YamlConfiguration();
        conf.set("pinned", data.getPinned());
        if (data.getSortFunction() != SortFunctions.NAME) {
            conf.set("sort", (Object)data.getSortFunction().ordinal());
        }
        if (data.isSortReversed()) {
            conf.set("reversed", (Object)true);
        }
        conf.save(userFile);
    }

    @Override
    public @Unmodifiable @NotNull Set<YAMLResidenceData> listResidences() {
        return Set.copyOf(this.residences.values());
    }

    @Override
    @Nullable
    public YAMLResidenceData getResidence(@NotNull String name) {
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByName(name);
        if (residence == null) {
            return null;
        }
        YAMLResidenceData existed = this.residences.get(name);
        if (existed != null) {
            return existed;
        }
        File dataFile = new File(this.residenceDataFolder, residence.getName() + ".yaml");
        YAMLResidenceData data = new YAMLResidenceData(dataFile, residence);
        this.residences.put(residence.getName(), data);
        return data;
    }

    public int loadAllResidences() {
        String[] filesList = this.residenceDataFolder.list();
        if (filesList == null || filesList.length < 1) {
            return 0;
        }
        List<File> files = Arrays.stream(filesList).map(s -> new File(this.residenceDataFolder, (String)s)).filter(File::isFile).toList();
        HashMap<String, YAMLResidenceData> loaded = new HashMap<String, YAMLResidenceData>();
        if (!files.isEmpty()) {
            for (File file : files) {
                String residenceName = file.getName().substring(0, file.getName().lastIndexOf("."));
                try {
                    YAMLResidenceData data = this.loadResidence(residenceName, file);
                    Main.debugging("Successfully loaded residence data for '" + residenceName + "' !");
                    loaded.put(residenceName, data);
                }
                catch (Exception ex) {
                    if (((Boolean)PluginConfig.SETTINGS.AUTO_REMOVE.getNotNull()).booleanValue()) {
                        file.delete();
                        Main.info("Removed invalid residence data #" + file.getAbsolutePath() + " !");
                        continue;
                    }
                    Main.severe("Error occurred when loading residence data #" + file.getAbsolutePath() + " !");
                    ex.printStackTrace();
                }
            }
        }
        this.residences = loaded;
        return loaded.size();
    }

    public YAMLResidenceData loadResidence(String residenceName, File file) throws Exception {
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByName(residenceName);
        if (residence == null) {
            throw new Exception("Residence not found: " + residenceName);
        }
        return new YAMLResidenceData(file, residence);
    }

    @Override
    @NotNull
    public YAMLResidenceData loadResidence(String residenceName) throws Exception {
        ClaimedResidence residence = Residence.getInstance().getResidenceManager().getByName(residenceName);
        if (residence == null) {
            throw new Exception("Residence not found: " + residenceName);
        }
        return new YAMLResidenceData(new File(this.residenceDataFolder, residence.getName() + ".yaml"), residence);
    }

    @Override
    public void renameResidence(String oldName, String newName) {
        YAMLResidenceData data = this.residences.remove(oldName);
        if (data == null) {
            return;
        }
        this.residences.put(newName, data);
        File n = new File(this.residenceDataFolder, newName + ".yaml");
        try {
            data.renameTo(n);
            Main.debugging("Successfully renamed residence data for '" + oldName + "' to '" + newName + "' !");
        }
        catch (Exception e) {
            Main.severe("Error occurred when renaming residence data for '" + oldName + "' to '" + newName + "' !");
            e.printStackTrace();
        }
    }

    @Override
    public void removeResidence(@NotNull String name) {
        YAMLResidenceData data = this.residences.remove(name);
        if (data == null) {
            return;
        }
        try {
            data.delete();
            Main.debugging("Successfully removed residence data for '" + name + "' !");
        }
        catch (Exception e) {
            Main.severe("Error occurred when removing residence data for '" + name + "' !");
            e.printStackTrace();
        }
    }

    @Override
    public boolean updateResidence(@NotNull ResidenceData data, @NotNull Consumer<ResidenceData> dataConsumer) {
        dataConsumer.accept(data);
        try {
            data.save();
        }
        catch (Exception e) {
            Main.severe("Error occurred when saving residence data for '" + data.getName() + "' !");
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void saveAllResidences() {
        for (ResidenceData residenceData : this.residences.values()) {
            try {
                residenceData.save();
            }
            catch (Exception e) {
                Main.severe("Error occurred when saving residence data for '" + residenceData.getName() + "' !");
                e.printStackTrace();
            }
        }
    }
}

