/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.storage.yaml.data;

import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.lib.xseries.XMaterial;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.io.File;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YAMLResidenceData
implements ResidenceData {
    @NotNull
    protected File file;
    @NotNull
    protected final FileConfiguration conf;
    @NotNull
    protected final ClaimedResidence residence;
    @Nullable
    protected Material icon;
    protected int customModelData;
    @Nullable
    protected String aliasName;
    @NotNull
    protected List<String> description;
    protected final Map<UUID, ResidenceRate> rates;

    public YAMLResidenceData(@NotNull File file, @NotNull ClaimedResidence residence) {
        this.file = file;
        this.conf = file.exists() ? YamlConfiguration.loadConfiguration((File)file) : new YamlConfiguration();
        this.residence = residence;
        String iconData = this.conf.getString("icon");
        if (iconData != null) {
            String[] args = iconData.split(":");
            this.icon = XMaterial.matchXMaterial(args[0]).map(XMaterial::parseMaterial).orElse(null);
            try {
                this.customModelData = args.length > 1 ? Integer.parseInt(args[1]) : -1;
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        this.aliasName = this.conf.getString("nickname", residence.getName());
        this.description = this.conf.getStringList("description");
        this.rates = YAMLResidenceData.loadRatesFrom(this.conf.getConfigurationSection("rates"));
    }

    @NotNull
    public FileConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    @NotNull
    public ClaimedResidence getResidence() {
        return this.residence;
    }

    @Override
    @Nullable
    public Material getIconMaterial() {
        return this.icon;
    }

    @Override
    public int getCustomModelData() {
        return this.customModelData;
    }

    @Override
    public void setIconMaterial(@NotNull Material material, int customModelData) {
        this.icon = material;
        this.customModelData = customModelData;
        if (customModelData > 0) {
            this.conf.set("icon", (Object)(XMaterial.matchXMaterial(material).name() + ":" + customModelData));
        } else {
            this.conf.set("icon", (Object)XMaterial.matchXMaterial(material).name());
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return Optional.ofNullable(this.getAliasName()).orElse(this.getName());
    }

    @Override
    @Nullable
    public String getAliasName() {
        return this.aliasName;
    }

    @Override
    public void setNickname(@NotNull String name) {
        this.aliasName = name;
        this.conf.set("nickname", (Object)name);
    }

    @Override
    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(@NotNull List<String> description) {
        this.description = description;
        this.conf.set("description", description);
    }

    @Override
    public void setDescription(String ... descriptions) {
        this.setDescription(List.of(descriptions));
    }

    @Override
    public boolean isPublicDisplayed() {
        return !this.getResidence().getPermissions().has(Flags.hidden, (Boolean)PluginConfig.SETTINGS.DEFAULT_STATUS.resolve() == false);
    }

    @Override
    public void setPublicDisplayed(boolean enabled) {
        this.getResidence().getPermissions().setFlag(Flags.hidden.name(), enabled ? FlagPermissions.FlagState.FALSE : FlagPermissions.FlagState.TRUE);
    }

    @Override
    public Map<UUID, ResidenceRate> getRates() {
        return this.rates;
    }

    @Override
    public void setRates(Map<UUID, ResidenceRate> rates) {
        this.rates.clear();
        this.rates.putAll(rates);
        this.conf.set("rates", null);
        rates.forEach((k, v) -> this.conf.set(k.toString(), this.serializeRate((ResidenceRate)v)));
    }

    @Override
    public void setRate(UUID uuid, ResidenceRate rate) {
        this.rates.put(uuid, rate);
        this.conf.set("rates." + uuid.toString(), this.serializeRate(rate));
    }

    @Override
    public void removeRate(UUID author) {
        this.rates.remove(author);
        this.conf.set(author.toString(), null);
    }

    @Override
    public void renameTo(@NotNull File newFile) throws Exception {
        if (this.file.exists()) {
            this.file.delete();
        }
        this.file = newFile;
        this.save();
    }

    public boolean delete() throws Exception {
        return this.file.exists() && this.file.delete();
    }

    @Override
    public void save() throws Exception {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.conf.save(this.file);
    }

    public Map<String, Object> serializeRate(@NotNull ResidenceRate rate) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("time", ResidenceListAPI.format(rate.time()));
        data.put("recommend", rate.recommend());
        data.put("content", rate.content());
        return data;
    }

    @NotNull
    public static Map<UUID, ResidenceRate> loadRatesFrom(@Nullable ConfigurationSection root) {
        LinkedHashMap<UUID, ResidenceRate> rates = new LinkedHashMap<UUID, ResidenceRate>();
        if (root == null) {
            return rates;
        }
        for (String key : root.getKeys(false)) {
            ConfigurationSection section = root.getConfigurationSection(key);
            if (section == null) continue;
            try {
                ResidenceRate rate = new ResidenceRate(UUID.fromString(section.getName()), section.getString("content", ""), section.getBoolean("recommend"), Optional.ofNullable(section.getString("time")).map(ResidenceListAPI::parse).orElse(LocalDateTime.now()));
                rates.put(rate.author(), rate);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return rates;
    }
}

