/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.ui;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.AutoPagedGUI;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.PreparedItem;
import com.artformgames.plugin.residencelist.listener.EditHandler;
import com.artformgames.plugin.residencelist.ui.ResidenceListUI;
import com.artformgames.plugin.residencelist.utils.GUIUtils;
import com.artformgames.plugin.residencelist.utils.ResidenceUtils;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceInfoUI
extends AutoPagedGUI {
    @NotNull
    protected final Player viewer;
    @NotNull
    protected final UserListData userData;
    @NotNull
    protected ResidenceData residenceData;
    @Nullable
    protected GUI previousGUI;

    public static void open(@NotNull Player player, @NotNull ResidenceData data, @Nullable GUI previousGUI) {
        UserListData user = ResidenceListAPI.getUserManager().getNullable(player.getUniqueId());
        if (user == null) {
            PluginMessages.LOAD_FAILED.sendTo(player, new Object[0]);
            return;
        }
        new ResidenceInfoUI(player, user, data, previousGUI).openGUI(player);
    }

    public ResidenceInfoUI(@NotNull Player viewer, @NotNull UserListData userData, @NotNull ResidenceData residenceData, @Nullable GUI previousGUI) {
        super(GUIType.SIX_BY_NINE, CONFIG.TITLE.parseLine(viewer, residenceData.getDisplayName()), 28, 52);
        this.viewer = viewer;
        this.userData = userData;
        this.residenceData = residenceData;
        this.previousGUI = previousGUI;
        this.setPreviousPageSlot(36);
        this.setNextPageSlot(44);
        this.setPreviousPageUI(PluginConfig.ICON.PAGE.PREVIOUS_PAGE.get(viewer));
        this.setNextPageUI(PluginConfig.ICON.PAGE.NEXT_PAGE.get(viewer));
        this.setNoPreviousPageUI(PluginConfig.ICON.PAGE.NO_PREVIOUS_PAGE.get(viewer));
        this.setNoNextPageUI(PluginConfig.ICON.PAGE.NO_NEXT_PAGE.get(viewer));
        this.setEmptyItem(PluginConfig.ICON.EMPTY.get(viewer));
        this.initItems();
        this.loadIcon();
        this.displayRates();
    }

    @NotNull
    public Player getViewer() {
        return this.viewer;
    }

    public UserListData getPlayerData() {
        return this.userData;
    }

    @NotNull
    public ResidenceData getResidenceData() {
        return this.residenceData;
    }

    public void initItems() {
        Location teleportLocation;
        if (this.previousGUI != null) {
            this.setItem(0, new GUIItem(CONFIG.ITEMS.BACK.get(this.viewer)){

                @Override
                public void onClick(Player player, ClickType clickType) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(player);
                    ResidenceInfoUI.this.previousGUI.openGUI(player);
                }
            });
        }
        if ((teleportLocation = this.getResidenceData().getTeleportLocation(this.getViewer())) != null && this.getResidenceData().canTeleport(this.getViewer())) {
            this.setItem(13, new GUIItem(CONFIG.ITEMS.TELEPORT_TO.prepare(this.getResidenceData().getResidence().getMainArea().getWorldName(), teleportLocation.getBlockX(), teleportLocation.getBlockY(), teleportLocation.getBlockZ()).get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    ResidenceInfoUI.this.residenceData.getResidence().tpToResidence(clicker, clicker, clicker.hasPermission("residence.admin"));
                    PluginMessages.TELEPORT.SOUND.playTo(clicker);
                }
            });
        } else {
            this.setItem(13, new GUIItem(CONFIG.ITEMS.TELEPORT_DISABLED.prepare(new Object[0]).get(this.getViewer())));
        }
        if (ResidenceUtils.isServerLand(this.getResidenceData().getResidence())) {
            this.setItem(14, new GUIItem(CONFIG.ITEMS.SERVER.prepare(new Object[0]).get(this.getViewer())));
        } else {
            this.setItem(14, new GUIItem(((PreparedItem)CONFIG.ITEMS.OWNER.prepare(this.getResidenceData().getOwner()).setSkullOwner(this.getResidenceData().getOwner())).get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    ResidenceListUI.open(ResidenceInfoUI.this.getViewer(), ResidenceInfoUI.this.getResidenceData().getOwner());
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceInfoUI.this.getViewer());
                }
            });
        }
        ResidenceRate rated = this.getResidenceData().getRates().get(this.getViewer().getUniqueId());
        ItemStack rateIcon = rated == null ? CONFIG.ITEMS.RATE.get(this.getViewer()) : ((PreparedItem)CONFIG.ITEMS.RATED.prepare(ResidenceListAPI.format(rated.time())).insert("comment", GUIUtils.sortContent(rated.content()))).get(this.getViewer());
        this.setItem(15, new GUIItem(rateIcon){

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (!type.isLeftClick() && !type.isRightClick()) {
                    return;
                }
                clicker.closeInventory();
                boolean recommend = type.isLeftClick();
                PluginMessages.COMMENT.NOTIFY.sendTo(clicker, ResidenceInfoUI.this.getResidenceData().getDisplayName());
                PluginMessages.COMMENT.ASK_SOUND.playTo(clicker);
                EditHandler.start(clicker, (player, content) -> {
                    ResidenceInfoUI.this.getResidenceData().modify(d -> d.addRate((String)content, recommend, ResidenceInfoUI.this.getViewer().getUniqueId()));
                    ResidenceInfoUI.open(player, ResidenceInfoUI.this.getResidenceData(), ResidenceInfoUI.this.previousGUI);
                    if (recommend) {
                        PluginMessages.COMMENT.YES_SOUND.playTo((Player)player);
                    } else {
                        PluginMessages.COMMENT.NO_SOUND.playTo((Player)player);
                    }
                });
            }
        });
    }

    public void displayRates() {
        this.container.clear();
        this.page = 1;
        this.setItem(16, new GUIItem(CONFIG.ITEMS.MEMBERS.prepare(this.getResidenceData().getResidence().getTrustedPlayers().size()).get(this.viewer)){

            @Override
            public void onClick(Player clicker, ClickType type) {
                ResidenceInfoUI.this.displayMembers();
                ResidenceInfoUI.this.openGUI(ResidenceInfoUI.this.viewer);
                PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceInfoUI.this.getViewer());
            }
        });
        if (this.getResidenceData().getRates().isEmpty()) {
            this.goFirstPage();
            this.setItem(40, new GUIItem(CONFIG.ITEMS.EMPTY.get(this.getViewer())));
            return;
        }
        for (ResidenceRate value : this.getResidenceData().getRates().values()) {
            ConfiguredItem item = value.recommend() ? PluginConfig.ICON.RATE.LIKE : PluginConfig.ICON.RATE.DISLIKE;
            PreparedItem preparedItem = item.prepare(Optional.ofNullable(value.getAuthorName()).orElse("?"), PluginConfig.DATETIME_FORMATTER.format(value.time()));
            preparedItem.setSkullOwner(value.author());
            preparedItem.insert("comment", GUIUtils.sortContent(value.content()));
            this.addItem(new GUIItem(preparedItem.get(this.getViewer())){});
        }
        this.goFirstPage();
    }

    public void displayMembers() {
        this.container.clear();
        this.setItem(16, new GUIItem(CONFIG.ITEMS.RATES.prepare(this.getResidenceData().getRates().size()).get(this.viewer)){

            @Override
            public void onClick(Player clicker, ClickType type) {
                ResidenceInfoUI.this.displayRates();
                ResidenceInfoUI.this.openGUI(ResidenceInfoUI.this.viewer);
                PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceInfoUI.this.getViewer());
            }
        });
        ClaimedResidence residence = this.getResidenceData().getResidence();
        if (!ResidenceUtils.isServerLand(this.getResidenceData().getResidence())) {
            this.addItem(new GUIItem(((PreparedItem)CONFIG.ITEMS.OWNER.prepare(this.getResidenceData().getOwner()).setSkullOwner(this.getResidenceData().getOwner())).get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    ResidenceListUI.open(ResidenceInfoUI.this.getViewer(), ResidenceInfoUI.this.getResidenceData().getOwner());
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceInfoUI.this.getViewer());
                }
            });
        }
        for (ResidencePlayer trustedPlayer : residence.getTrustedPlayers()) {
            this.addItem(new GUIItem(((PreparedItem)CONFIG.ITEMS.PLAYER.prepare(trustedPlayer.getName(), trustedPlayer.getUniqueId()).setSkullOwner(trustedPlayer.getName())).get(this.viewer)));
        }
        this.goFirstPage();
    }

    public void loadIcon() {
        this.setItem(11, this.generateIcon(this.getPlayerData(), this.getResidenceData().getResidence()));
    }

    protected GUIItem generateIcon(final UserListData userData, final ClaimedResidence residence) {
        Object residenceData = Main.getInstance().getResidenceManager().getResidence(residence);
        PreparedItem icon = PluginConfig.ICON.INFO.prepare(this.residenceData.getDisplayName(), this.residenceData.getOwner(), residence.getTrustedPlayers().size() + 1, residence.getMainArea().getSize(), this.residenceData.countRate(ResidenceRate::recommend), this.residenceData.countRate(r -> !r.recommend()));
        icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.CLICK, new Object[0]);
        if (!this.getResidenceData().getDescription().isEmpty()) {
            icon.insert("description", this.getResidenceData().getDescription());
        }
        if (userData.isPinned(residence.getName())) {
            icon.glow();
        }
        if (this.residenceData.getIconMaterial() != null) {
            icon.handleItem((i, p) -> i.setType(this.residenceData.getIconMaterial()));
            if (this.residenceData.getCustomModelData() > 0) {
                icon.handleMeta((itemMeta, player) -> itemMeta.setCustomModelData(Integer.valueOf(this.residenceData.getCustomModelData())));
            }
        }
        return new GUIItem(icon.get(this.viewer), (ResidenceData)residenceData){
            final /* synthetic */ ResidenceData val$residenceData;
            {
                this.val$residenceData = residenceData;
                super(display);
            }

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (!type.isLeftClick()) {
                    return;
                }
                if (userData.isPinned(residence.getName())) {
                    userData.removePin(residence.getName());
                    PluginMessages.UNPIN.SOUND.playTo(clicker);
                    PluginMessages.UNPIN.MESSAGE.sendTo(clicker, this.val$residenceData.getDisplayName());
                } else {
                    userData.setPin(residence.getName(), 0);
                    PluginMessages.PIN.SOUND.playTo(clicker);
                    PluginMessages.PIN.MESSAGE.sendTo(clicker, this.val$residenceData.getDisplayName());
                }
                ResidenceInfoUI.this.loadIcon();
                ResidenceInfoUI.this.updateView();
            }
        };
    }

    public static interface CONFIG
    extends Configuration {
        public static final ConfiguredMessage<String> TITLE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a&lDetails &7#&f%(name)")).params("name")).build();

        public static interface ADDITIONAL_LORE
        extends Configuration {
            public static final ConfiguredMessage<String> CLICK = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 Click &8|&f Pin/Unpin residence")).build();
        }

        public static interface ITEMS
        extends Configuration {
            public static final ConfiguredItem BACK = ConfiguredItem.create().defaultType(Material.REDSTONE_TORCH).defaultName("&cBack").build();
            public static final ConfiguredItem OWNER = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&7Residence owned by &f%(owner)").defaultLore("&7", "&a \u25b6 Click &8|&f See all his residences").params("owner").build();
            public static final ConfiguredItem SERVER = ConfiguredItem.create().defaultType(Material.CREEPER_HEAD).defaultName("&e&oServer Residence").defaultLore("&7").build();
            public static final ConfiguredItem TELEPORT_TO = ConfiguredItem.create().defaultType(Material.ENDER_EYE).defaultName("&dTeleport to residence").defaultLore("&7", "&7Residence location:", "&f%(world)&7@&f%(x)&7,&f%(y),&f%(z)", "", "&a \u25b6 Click &8|&f Teleport to residence.").params("world", "x", "y", "z").build();
            public static final ConfiguredItem TELEPORT_DISABLED = ConfiguredItem.create().defaultType(Material.ENDER_EYE).defaultName("&d&mTeleport").defaultLore("&7", "&cThis residence cannot be teleported to.", "").build();
            public static final ConfiguredItem PLAYER = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&a%(name)").defaultLore("&7").params("name", "uuid").build();
            public static final ConfiguredItem MEMBERS = ConfiguredItem.create().defaultType(Material.FURNACE).defaultName("&eMembers").defaultLore("&7", "&7This residence has &f%(members) &7members.", "&7", "&a \u25b6 Click &8|&f See all members.").params("members").build();
            public static final ConfiguredItem RATES = ConfiguredItem.create().defaultType(Material.COPPER_BLOCK).defaultName("&eRates").defaultLore("&7", "&7This residence has &f%(size) &7rates.", "&7", "&a \u25b6 Click &8|&f See all rates.").params("size").build();
            public static final ConfiguredItem RATE = ConfiguredItem.create().defaultType(Material.WRITABLE_BOOK).defaultName("&eRate && Comment").defaultLore("&7", "&7You can rate and comment on this residence.", "&7", "&a \u25b6 LClick &8|&f Like && comment.", "&a \u25b6 RClick &8|&f Dislike && comment.").build();
            public static final ConfiguredItem RATED = ConfiguredItem.create().defaultType(Material.WRITTEN_BOOK).defaultName("&eRate && Comment").defaultLore("&7", "&7You have already rated and commented:", "{&7- &f&o}#comment#", "&7Rate at &f%(date)", " ", "&7You can still update your comment.", "&7", "&a \u25b6 LClick &8|&f Like && comment.", "&a \u25b6 RClick &8|&f Dislike && comment.").params("date").build();
            public static final ConfiguredItem EMPTY = ConfiguredItem.create().defaultType(Material.BARRIER).defaultName("&7Empty").defaultLore("&7There are no comments yet.").build();
        }
    }
}

