/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.ui;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.api.sort.SortFunctions;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.AutoPagedGUI;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.PreparedItem;
import com.artformgames.plugin.residencelist.ui.ResidenceInfoUI;
import com.artformgames.plugin.residencelist.ui.ResidenceManageUI;
import com.artformgames.plugin.residencelist.utils.ResidenceUtils;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.ArrayList;
import java.util.Comparator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceListUI
extends AutoPagedGUI {
    @NotNull
    protected final Player viewer;
    @NotNull
    protected final UserListData data;
    @Nullable
    protected String owner;

    public static void open(@NotNull Player player, @Nullable String owner) {
        UserListData data = ResidenceListAPI.getUserManager().getNullable(player.getUniqueId());
        if (data == null) {
            PluginMessages.LOAD_FAILED.sendTo(player, new Object[0]);
            return;
        }
        new ResidenceListUI(player, data, owner).openGUI(player);
    }

    public ResidenceListUI(@NotNull Player viewer, @NotNull UserListData data, @Nullable String owner) {
        super(GUIType.SIX_BY_NINE, "", 10, 34);
        this.viewer = viewer;
        this.data = data;
        this.owner = owner;
        this.setPreviousPageSlot(47);
        this.setNextPageSlot(51);
        this.setPreviousPageUI(PluginConfig.ICON.PAGE.PREVIOUS_PAGE.get(viewer));
        this.setNextPageUI(PluginConfig.ICON.PAGE.NEXT_PAGE.get(viewer));
        this.setNoPreviousPageUI(PluginConfig.ICON.PAGE.NO_PREVIOUS_PAGE.get(viewer));
        this.setNoNextPageUI(PluginConfig.ICON.PAGE.NO_NEXT_PAGE.get(viewer));
        this.setEmptyItem(PluginConfig.ICON.EMPTY.get(viewer));
        this.initItems();
        this.loadResidences();
        this.title = CONFIG.TITLE.parseLine(viewer, 1, this.getLastPageNumber());
    }

    @NotNull
    public Player getViewer() {
        return this.viewer;
    }

    @NotNull
    public UserListData getPlayerData() {
        return this.data;
    }

    public boolean checkOwner(ClaimedResidence residence) {
        return this.owner == null || residence.isOwner(this.owner);
    }

    public void initItems() {
        if (this.owner != null) {
            this.setItem(49, new GUIItem(((PreparedItem)CONFIG.ITEMS.OWNED.prepare(this.owner).setSkullOwner(this.owner)).get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    clicker.closeInventory();
                    ResidenceListUI.open(clicker, null);
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceListUI.this.getViewer());
                }
            });
        } else {
            this.setItem(49, new GUIItem(CONFIG.ITEMS.ALL.get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    clicker.closeInventory();
                    ResidenceListUI.open(clicker, clicker.getName());
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceListUI.this.getViewer());
                }
            });
        }
        ConfiguredItem sortItem = switch (this.getPlayerData().getSortFunction()) {
            default -> throw new IncompatibleClassChangeError();
            case SortFunctions.NAME -> CONFIG.ITEMS.SORT_BY_NAME;
            case SortFunctions.SIZE -> CONFIG.ITEMS.SORT_BY_SIZE;
            case SortFunctions.RATINGS -> CONFIG.ITEMS.SORT_BY_RATINGS;
        };
        this.setItem(53, new GUIItem(sortItem.get(this.getViewer(), this.getPlayerData().isSortReversed() ? "\u2b07" : "\u2b06")){

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isRightClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceListUI.this.getViewer());
                    ResidenceListUI.this.getPlayerData().setSortReversed(!ResidenceListUI.this.getPlayerData().isSortReversed());
                    ResidenceListUI.open(clicker, ResidenceListUI.this.owner);
                } else if (type.isLeftClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceListUI.this.getViewer());
                    ResidenceListUI.this.getPlayerData().setSortFunction(ResidenceListUI.this.getPlayerData().getSortFunction().next());
                    ResidenceListUI.open(clicker, ResidenceListUI.this.owner);
                }
            }
        });
    }

    @Override
    public void onPageChange(int pageNum) {
        PluginConfig.GUI.CLICK_SOUND.playTo(this.getViewer());
        this.updateTitle(CONFIG.TITLE.parseLine(this.viewer, pageNum, this.getLastPageNumber()));
    }

    public void loadResidences() {
        this.container.clear();
        UserListData data = this.getPlayerData();
        ArrayList display = new ArrayList();
        Comparator<ClaimedResidence> comparator = data.getSortFunction().residenceComparator(data.isSortReversed());
        data.getPinned().stream().map(ResidenceListAPI::getResidence).filter(res -> res != null && this.checkOwner((ClaimedResidence)res)).filter(res -> ResidenceUtils.viewable(res, this.viewer)).sorted(comparator).forEach(display::add);
        ResidenceListAPI.listResidences().stream().filter(res -> !display.contains(res)).filter(this::checkOwner).filter(res -> ResidenceUtils.viewable(res, this.viewer)).sorted(comparator).forEach(display::add);
        display.stream().filter(r -> {
            Object d = Main.getInstance().getResidenceManager().getResidence((ClaimedResidence)r);
            return d.isPublicDisplayed() || d.isOwner(this.getViewer());
        }).forEach(residence -> this.addItem(ResidenceListUI.generateIcon(this.getViewer(), this, this.owner, data, residence)));
    }

    protected static GUIItem generateIcon(Player viewer, GUI previous, String filterOwner, final UserListData userData, final ClaimedResidence residence) {
        Object data = Main.getInstance().getResidenceManager().getResidence(residence);
        PreparedItem icon = PluginConfig.ICON.INFO.prepare(data.getDisplayName(), data.getOwner(), residence.getTrustedPlayers().size() + 1, residence.getMainArea().getSize(), data.countRate(ResidenceRate::recommend), data.countRate(r -> !r.recommend()));
        if (data.canTeleport(viewer)) {
            icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.TELEPORTABLE, new Object[0]);
        } else {
            icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.NORMAL, new Object[0]);
        }
        if (!data.getDescription().isEmpty()) {
            icon.insert("description", data.getDescription());
        }
        if (userData.isPinned(residence.getName())) {
            icon.glow();
        }
        if (data.getIconMaterial() != null) {
            icon.handleItem((i, p) -> i.setType(data.getIconMaterial()));
            if (data.getCustomModelData() > 0) {
                icon.handleMeta((itemMeta, player) -> itemMeta.setCustomModelData(Integer.valueOf(data.getCustomModelData())));
            }
        }
        return new GUIItem(icon.get(viewer), (ResidenceData)data, viewer, filterOwner, previous){
            final /* synthetic */ ResidenceData val$data;
            final /* synthetic */ Player val$viewer;
            final /* synthetic */ String val$filterOwner;
            final /* synthetic */ GUI val$previous;
            {
                this.val$data = residenceData;
                this.val$viewer = player;
                this.val$filterOwner = string;
                this.val$previous = gUI;
                super(display);
            }

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type == ClickType.DROP || type == ClickType.CONTROL_DROP) {
                    if (userData.isPinned(residence.getName())) {
                        userData.removePin(residence.getName());
                        PluginMessages.UNPIN.SOUND.playTo(clicker);
                        PluginMessages.UNPIN.MESSAGE.sendTo(clicker, this.val$data.getDisplayName());
                    } else {
                        userData.setPin(residence.getName(), 0);
                        PluginMessages.PIN.SOUND.playTo(clicker);
                        PluginMessages.PIN.MESSAGE.sendTo(clicker, this.val$data.getDisplayName());
                    }
                    ResidenceListUI.open(this.val$viewer, this.val$filterOwner);
                } else if (type.isLeftClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(this.val$viewer);
                    if (this.val$data.isOwner(clicker)) {
                        ResidenceManageUI.open(this.val$viewer, this.val$data, this.val$previous);
                    } else {
                        ResidenceInfoUI.open(this.val$viewer, this.val$data, this.val$previous);
                    }
                } else if (type.isRightClick()) {
                    if (!this.val$data.canTeleport(this.val$viewer)) {
                        return;
                    }
                    Location target = this.val$data.getTeleportLocation(this.val$viewer);
                    if (target == null) {
                        PluginMessages.TELEPORT.NO_LOCATION.sendTo(clicker, this.val$data.getDisplayName());
                        return;
                    }
                    this.val$data.getResidence().tpToResidence(clicker, clicker, clicker.hasPermission("residence.admin"));
                    PluginMessages.TELEPORT.SOUND.playTo(clicker);
                }
            }
        };
    }

    public static interface CONFIG
    extends Configuration {
        public static final ConfiguredMessage<String> TITLE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a&lResidence list &7(&f%(current_page)&7/%(total_page))")).params("current_page", "total_page")).build();

        public static interface ADDITIONAL_LORE
        extends Configuration {
            public static final ConfiguredMessage<String> NORMAL = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 Click &8|&f View information", "&a \u25b6 Drop &8|&f Pin/Unpin residence")).build();
            public static final ConfiguredMessage<String> TELEPORTABLE = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 LClick &8|&f View information", "&a \u25b6 RClick &8|&f Teleport to residence", "&a \u25b6  Drop  &8|&f Pin/Unpin residence")).build();
        }

        public static interface ITEMS
        extends Configuration {
            public static final ConfiguredItem ALL = ConfiguredItem.create().defaultType(Material.CHEST).defaultName("&a&lAll residences").defaultLore("&7", "&7Now all residences are displayed.", "&7", "&a \u25b6 Click &8|&f See only personal residences").build();
            public static final ConfiguredItem OWNED = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&7Residence owned by &f%(owner)").defaultLore("&7", "&a \u25b6 Click &8|&f See all residences").params("owner").build();
            public static final ConfiguredItem SORT_BY_RATINGS = ConfiguredItem.create().defaultType(Material.LADDER).defaultName("&fSort by &e&lRATINGS %(order)").defaultLore("&7", "&fSort order: %(order)", "&fSort functions:", "&7 &a\u27a5 &e&lRATINGS", "&7     &fNAME", "&7     &fSIZE", " ", "&a \u25b6 LClick &8|&f Switch sort function", "&a \u25b6 RClick &8|&f Toggle sort reverse").params("order").build();
            public static final ConfiguredItem SORT_BY_NAME = ConfiguredItem.create().defaultType(Material.LADDER).defaultName("&fSort by &2&lNAME %(order)").defaultLore("&7", "&fSort order: %(order)", "&fSort functions:", "&7     &fRATINGS", "&7 &a\u27a5 &2&lNAME", "&7     &fSIZE", " ", "&a \u25b6 LClick &8|&f Switch sort function", "&a \u25b6 RClick &8|&f Toggle sort reverse").params("order").build();
            public static final ConfiguredItem SORT_BY_SIZE = ConfiguredItem.create().defaultType(Material.LADDER).defaultName("&fSort by &d&lSIZE %(order)").defaultLore("&7", "&fSort order: %(order)", "&fSort functions:", "&7     &fRATINGS", "&7     &fNAME", "&7  &a\u27a5 &d&lSIZE", " ", "&a \u25b6 LClick &8|&f Switch sort function", "&a \u25b6 RClick &8|&f Toggle sort reverse").params("order").build();
        }
    }
}

