/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.ui;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.AutoPagedGUI;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.PreparedItem;
import com.artformgames.plugin.residencelist.listener.EditHandler;
import com.artformgames.plugin.residencelist.ui.SelectIconGUI;
import com.artformgames.plugin.residencelist.utils.GUIUtils;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceManageUI
extends AutoPagedGUI {
    @NotNull
    protected Player viewer;
    @NotNull
    protected final UserListData userData;
    @NotNull
    protected final ResidenceData residenceData;
    @Nullable
    protected GUI previousGUI;

    public static void open(@NotNull Player player, @NotNull ResidenceData data, @Nullable GUI previousGUI) {
        UserListData user = ResidenceListAPI.getUserManager().getNullable(player.getUniqueId());
        if (user == null) {
            PluginMessages.LOAD_FAILED.sendTo(player, new Object[0]);
            return;
        }
        new ResidenceManageUI(player, user, data, previousGUI).openGUI(player);
    }

    public ResidenceManageUI(@NotNull Player viewer, @NotNull UserListData userData, @NotNull ResidenceData residenceData, @Nullable GUI previousGUI) {
        super(GUIType.SIX_BY_NINE, CONFIG.TITLE.parseLine(viewer, residenceData.getDisplayName()), 28, 52);
        this.viewer = viewer;
        this.userData = userData;
        this.residenceData = residenceData;
        this.previousGUI = previousGUI;
        this.setPreviousPageSlot(36);
        this.setNextPageSlot(44);
        this.setPreviousPageUI(PluginConfig.ICON.PAGE.PREVIOUS_PAGE.get(viewer));
        this.setNextPageUI(PluginConfig.ICON.PAGE.NEXT_PAGE.get(viewer));
        this.setNoPreviousPageUI(PluginConfig.ICON.PAGE.NO_PREVIOUS_PAGE.get(viewer));
        this.setNoNextPageUI(PluginConfig.ICON.PAGE.NO_NEXT_PAGE.get(viewer));
        this.setEmptyItem(PluginConfig.ICON.EMPTY.get(viewer));
        this.initItems();
        this.loadIcon();
        this.loadStatus();
        this.loadRates();
    }

    @NotNull
    public Player getViewer() {
        return this.viewer;
    }

    public UserListData getPlayerData() {
        return this.userData;
    }

    @NotNull
    public ResidenceData getResidenceData() {
        return this.residenceData;
    }

    public void loadIcon() {
        this.setItem(11, this.generateIcon(this.getPlayerData(), this.getResidenceData().getResidence()));
    }

    public void initItems() {
        if (this.previousGUI != null) {
            this.setItem(0, new GUIItem(CONFIG.ITEMS.BACK.get(this.viewer)){

                @Override
                public void onClick(Player player, ClickType clickType) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(player);
                    ResidenceManageUI.this.previousGUI.openGUI(player);
                }
            });
        }
        Location teleportLocation = this.getResidenceData().getTeleportLocation(this.getViewer(), this.getViewer().getLocation());
        this.setItem(13, new GUIItem(CONFIG.ITEMS.TELEPORT.prepare(this.getResidenceData().getResidence().getMainArea().getWorldName(), teleportLocation.getBlockX(), teleportLocation.getBlockY(), teleportLocation.getBlockZ()).get(this.getViewer())){

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isLeftClick()) {
                    ResidenceManageUI.this.getResidenceData().getResidence().tpToResidence(clicker, clicker, clicker.hasPermission("residence.admin"));
                    PluginMessages.TELEPORT.SOUND.playTo(clicker);
                } else if (type.isRightClick()) {
                    ResidenceManageUI.this.getResidenceData().getResidence().setTpLoc(clicker, clicker.hasPermission("residence.admin"));
                    PluginConfig.GUI.CLICK_SOUND.playTo(clicker);
                }
            }
        });
        this.setItem(14, new GUIItem(CONFIG.ITEMS.INFORMATION.get(this.getViewer())){

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isShiftClick()) {
                    clicker.closeInventory();
                    PluginMessages.EDIT.EDIT_SOUND.playTo(ResidenceManageUI.this.getViewer());
                    SelectIconGUI.open(clicker, (player, itemStack) -> {
                        Material material = itemStack.getType();
                        if (PluginConfig.SETTINGS.BLOCKED_ICON_TYPES.contains(material)) {
                            PluginMessages.EDIT.ICON_BLOCKED.sendTo(player, ResidenceManageUI.this.getResidenceData().getDisplayName());
                            PluginMessages.EDIT.FAILED_SOUND.playTo((Player)player);
                        } else {
                            ResidenceManageUI.this.getResidenceData().modify(d -> d.setIconMaterial((ItemStack)itemStack));
                            PluginMessages.EDIT.ICON_UPDATED.sendTo(player, ResidenceManageUI.this.getResidenceData().getDisplayName());
                            PluginMessages.EDIT.SUCCESS_SOUND.playTo((Player)player);
                        }
                        ResidenceManageUI.this.loadIcon();
                        ResidenceManageUI.this.openGUI((Player)player);
                    });
                } else if (type.isLeftClick()) {
                    clicker.closeInventory();
                    PluginMessages.EDIT.EDIT_SOUND.playTo(ResidenceManageUI.this.getViewer());
                    PluginMessages.EDIT.NAME.sendTo(ResidenceManageUI.this.getViewer(), ResidenceManageUI.this.getResidenceData().getDisplayName());
                    EditHandler.start(ResidenceManageUI.this.getViewer(), (player, content) -> {
                        ResidenceManageUI.this.setItem(11, ResidenceManageUI.this.generateIcon(ResidenceManageUI.this.getPlayerData(), ResidenceManageUI.this.getResidenceData().getResidence()));
                        if (content.length() > 16) {
                            PluginMessages.EDIT.NAME_TOO_LONG.sendTo(player, new Object[0]);
                            PluginMessages.EDIT.FAILED_SOUND.playTo((Player)player);
                            return;
                        }
                        ResidenceManageUI.this.getResidenceData().modify(d -> d.setNickname((String)content));
                        PluginMessages.EDIT.NAME_UPDATED.sendTo(player, ResidenceManageUI.this.getResidenceData().getDisplayName());
                        PluginMessages.EDIT.SUCCESS_SOUND.playTo((Player)player);
                        ResidenceManageUI.this.loadIcon();
                        ResidenceManageUI.this.openGUI((Player)player);
                    });
                } else if (type.isRightClick()) {
                    clicker.closeInventory();
                    PluginMessages.EDIT.EDIT_SOUND.playTo(ResidenceManageUI.this.getViewer());
                    PluginMessages.EDIT.DESCRIPTION.sendTo(ResidenceManageUI.this.getViewer(), ResidenceManageUI.this.getResidenceData().getDisplayName());
                    EditHandler.start(ResidenceManageUI.this.getViewer(), (player, content) -> {
                        ResidenceManageUI.this.getResidenceData().modify(d -> d.setDescription(content.split("\\\\n")));
                        PluginMessages.EDIT.DESCRIPTION_UPDATED.sendTo(player, ResidenceManageUI.this.getResidenceData().getDisplayName());
                        PluginMessages.EDIT.SUCCESS_SOUND.playTo((Player)player);
                        ResidenceManageUI.this.loadIcon();
                        ResidenceManageUI.this.openGUI((Player)player);
                    });
                }
            }
        });
    }

    public void loadStatus() {
        if (this.getResidenceData().isPublicDisplayed()) {
            this.setItem(15, new GUIItem(CONFIG.ITEMS.PUBLIC.get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    ResidenceManageUI.this.getResidenceData().modify(d -> d.setPublicDisplayed(false));
                    PluginMessages.EDIT.SUCCESS_SOUND.playTo(clicker);
                    ResidenceManageUI.this.loadStatus();
                    ResidenceManageUI.this.updateView();
                }
            });
        } else {
            this.setItem(15, new GUIItem(CONFIG.ITEMS.PRIVATE.get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    ResidenceManageUI.this.getResidenceData().modify(d -> d.setPublicDisplayed(true));
                    PluginMessages.EDIT.SUCCESS_SOUND.playTo(clicker);
                    ResidenceManageUI.this.loadStatus();
                    ResidenceManageUI.this.updateView();
                }
            });
        }
    }

    public void loadRates() {
        if (this.getResidenceData().getRates().isEmpty()) {
            this.setItem(40, new GUIItem(CONFIG.ITEMS.EMPTY.get(this.getViewer())));
            return;
        }
        for (final ResidenceRate value : this.getResidenceData().getRates().values()) {
            ConfiguredItem item = value.recommend() ? PluginConfig.ICON.RATE.LIKE : PluginConfig.ICON.RATE.DISLIKE;
            PreparedItem preparedItem = item.prepare(Optional.ofNullable(value.getAuthorName()).orElse("?"), PluginConfig.DATETIME_FORMATTER.format(value.time()));
            preparedItem.setSkullOwner(value.author());
            preparedItem.insert("comment", GUIUtils.sortContent(value.content()));
            if (this.getViewer().hasPermission("residence.admin")) {
                preparedItem.insert("click-lore", CONFIG.ADDITIONAL_LORE.REMOVE, new Object[0]);
            }
            this.addItem(new GUIItem(preparedItem.get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    if (ResidenceManageUI.this.getViewer().hasPermission("residence.admin")) {
                        ResidenceManageUI.this.getResidenceData().removeRate(value.author());
                        PluginMessages.EDIT.SUCCESS_SOUND.playTo(clicker);
                        ResidenceManageUI.open(ResidenceManageUI.this.getViewer(), ResidenceManageUI.this.residenceData, ResidenceManageUI.this.previousGUI);
                    }
                }
            });
        }
    }

    protected GUIItem generateIcon(final UserListData userData, final ClaimedResidence residence) {
        Object residenceData = Main.getInstance().getResidenceManager().getResidence(residence);
        PreparedItem icon = PluginConfig.ICON.INFO.prepare(this.residenceData.getDisplayName(), this.residenceData.getOwner(), residence.getTrustedPlayers().size() + 1, residence.getMainArea().getSize(), this.residenceData.countRate(ResidenceRate::recommend), this.residenceData.countRate(r -> !r.recommend()));
        icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.CLICK, new Object[0]);
        if (!this.getResidenceData().getDescription().isEmpty()) {
            icon.insert("description", this.getResidenceData().getDescription());
        }
        if (userData.isPinned(residence.getName())) {
            icon.glow();
        }
        if (this.residenceData.getIconMaterial() != null) {
            icon.handleItem((i, p) -> i.setType(this.residenceData.getIconMaterial()));
            if (this.residenceData.getCustomModelData() > 0) {
                icon.handleMeta((itemMeta, player) -> itemMeta.setCustomModelData(Integer.valueOf(this.residenceData.getCustomModelData())));
            }
        }
        return new GUIItem(icon.get(this.viewer), (ResidenceData)residenceData){
            final /* synthetic */ ResidenceData val$residenceData;
            {
                this.val$residenceData = residenceData;
                super(display);
            }

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isLeftClick()) {
                    if (userData.isPinned(residence.getName())) {
                        userData.removePin(residence.getName());
                        PluginMessages.UNPIN.SOUND.playTo(clicker);
                        PluginMessages.UNPIN.MESSAGE.sendTo(clicker, this.val$residenceData.getDisplayName());
                    } else {
                        userData.setPin(residence.getName(), 0);
                        PluginMessages.PIN.SOUND.playTo(clicker);
                        PluginMessages.PIN.MESSAGE.sendTo(clicker, this.val$residenceData.getDisplayName());
                    }
                    ResidenceManageUI.this.loadIcon();
                    ResidenceManageUI.this.updateView();
                }
            }
        };
    }

    public static interface CONFIG
    extends Configuration {
        public static final ConfiguredMessage<String> TITLE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a&lDetails &7#&f%(name)")).params("name")).build();

        public static interface ADDITIONAL_LORE
        extends Configuration {
            public static final ConfiguredMessage<String> CLICK = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 LClick &8|&f Pin/Unpin residence")).build();
            public static final ConfiguredMessage<String> REMOVE = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 LClick &8|&f Delete this comment &c(ADMIN)")).build();
        }

        public static interface ITEMS
        extends Configuration {
            public static final ConfiguredItem BACK = ConfiguredItem.create().defaultType(Material.REDSTONE_TORCH).defaultName("&cBack").build();
            public static final ConfiguredItem TELEPORT = ConfiguredItem.create().defaultType(Material.ENDER_EYE).defaultName("&d&lTeleport").defaultLore("&7", "&7Residence location:", "&f%(world)&7@&f%(x)&7,&f%(y),&f%(z)", "", "&a \u25b6 LClick &8|&f Teleport to residence.", "&a \u25b6 RClick &8|&f Set current location for teleportation.").params("world", "x", "y", "z").build();
            public static final ConfiguredItem INFORMATION = ConfiguredItem.create().defaultType(Material.OAK_SIGN).defaultName("&e&lEdit information").defaultLore("", "&a \u25b6 LClick &8|&f Set residence's nickname.", "&a \u25b6 RClick &8|&f Set residence's description.", "&a \u25b6 Shift+Click &8|&f Edit residence's icon").build();
            public static final ConfiguredItem PUBLIC = ConfiguredItem.create().defaultType(Material.LIME_DYE).defaultName("&7Current: &a&lPublic").defaultLore(" ", "&7Now all players can see this residence in list.", " ", "&a \u25b6 Click &8|&f Change to &c&lPrivate").build();
            public static final ConfiguredItem PRIVATE = ConfiguredItem.create().defaultType(Material.GRAY_DYE).defaultName("&7Current: &c&lPrivate").defaultLore(" ", "&7Now only you can see this residence in list.", "&7Others can't see it.", " ", "&a \u25b6 Click &8|&f Change to &a&lPublic").build();
            public static final ConfiguredItem EMPTY = ConfiguredItem.create().defaultType(Material.BARRIER).defaultName("&7Empty").defaultLore("&7There are no comments yet.").build();
        }
    }
}

