/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.ui;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUI;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import java.util.function.BiConsumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SelectIconGUI
extends GUI {
    @NotNull
    protected final Player player;
    @NotNull
    protected final BiConsumer<Player, ItemStack> callback;

    public static void open(@NotNull Player player, @NotNull BiConsumer<Player, ItemStack> callback) {
        new SelectIconGUI(player, callback).openGUI(player);
    }

    public SelectIconGUI(@NotNull Player player, @NotNull BiConsumer<Player, ItemStack> callback) {
        super(GUIType.ONE_BY_NINE, CONFIG.TITLE.parseLine(player, new Object[0]));
        this.player = player;
        this.callback = callback;
        this.setItem(4, new GUIItem(CONFIG.ITEMS.SELECT.get(player)));
        this.setEmptyItem(PluginConfig.ICON.EMPTY.get(player));
    }

    @Override
    public void rawClickListener(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!event.getClickedInventory().equals((Object)this.player.getInventory())) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        this.player.closeInventory();
        Main.getInstance().getScheduler().run(() -> this.callback.accept(this.player, clickedItem));
    }

    public static interface CONFIG
    extends Configuration {
        public static final ConfiguredMessage<String> TITLE = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a&lPlease select icon")).build();

        public static interface ITEMS
        extends Configuration {
            public static final ConfiguredItem SELECT = ConfiguredItem.create().defaultType(Material.LIME_DYE).defaultName("&7Click items in backpack").defaultLore(" ", "&7Please click items in backpack to select icon.", " ").build();
        }
    }
}

