/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.ui.admin;

import com.artformgames.plugin.residencelist.Main;
import com.artformgames.plugin.residencelist.ResidenceListAPI;
import com.artformgames.plugin.residencelist.api.residence.ResidenceData;
import com.artformgames.plugin.residencelist.api.residence.ResidenceRate;
import com.artformgames.plugin.residencelist.api.sort.SortFunctions;
import com.artformgames.plugin.residencelist.api.user.UserListData;
import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.artformgames.plugin.residencelist.conf.PluginMessages;
import com.artformgames.plugin.residencelist.lib.configuration.Configuration;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIItem;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.GUIType;
import com.artformgames.plugin.residencelist.lib.easyplugin.gui.paged.AutoPagedGUI;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.ConfiguredMessage;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.ConfiguredItem;
import com.artformgames.plugin.residencelist.lib.mineconfiguration.bukkit.value.item.PreparedItem;
import com.artformgames.plugin.residencelist.ui.ResidenceListUI;
import com.artformgames.plugin.residencelist.ui.ResidenceManageUI;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Comparator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidenceAdminUI
extends AutoPagedGUI {
    @NotNull
    protected final Player viewer;
    @NotNull
    protected final UserListData data;
    @Nullable
    protected String owner;

    public static void open(@NotNull Player player, @Nullable String owner) {
        UserListData data = ResidenceListAPI.getUserManager().getNullable(player.getUniqueId());
        if (data == null) {
            PluginMessages.LOAD_FAILED.sendTo(player, new Object[0]);
            return;
        }
        new ResidenceAdminUI(player, data, owner).openGUI(player);
    }

    public ResidenceAdminUI(@NotNull Player viewer, @NotNull UserListData data, @Nullable String owner) {
        super(GUIType.SIX_BY_NINE, "", 10, 34);
        this.viewer = viewer;
        this.data = data;
        this.owner = owner;
        this.setPreviousPageSlot(47);
        this.setNextPageSlot(51);
        this.setPreviousPageUI(PluginConfig.ICON.PAGE.PREVIOUS_PAGE.get(viewer));
        this.setNextPageUI(PluginConfig.ICON.PAGE.NEXT_PAGE.get(viewer));
        this.setNoPreviousPageUI(PluginConfig.ICON.PAGE.NO_PREVIOUS_PAGE.get(viewer));
        this.setNoNextPageUI(PluginConfig.ICON.PAGE.NO_NEXT_PAGE.get(viewer));
        this.setEmptyItem(PluginConfig.ICON.EMPTY.get(viewer));
        this.initItems();
        this.loadResidences();
        this.title = CONFIG.TITLE.parseLine(viewer, 1, this.getLastPageNumber());
    }

    @NotNull
    public Player getViewer() {
        return this.viewer;
    }

    public UserListData getPlayerData() {
        return this.data;
    }

    public boolean checkOwner(ClaimedResidence residence) {
        return this.owner == null || residence.isOwner(this.owner);
    }

    public void initItems() {
        if (this.owner != null) {
            this.setItem(49, new GUIItem(((PreparedItem)CONFIG.ITEMS.OWNED.prepare(this.owner).setSkullOwner(this.owner)).get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    clicker.closeInventory();
                    ResidenceAdminUI.open(clicker, null);
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceAdminUI.this.getViewer());
                }
            });
        } else {
            this.setItem(49, new GUIItem(CONFIG.ITEMS.ALL.get(this.getViewer())){

                @Override
                public void onClick(Player clicker, ClickType type) {
                    clicker.closeInventory();
                    ResidenceAdminUI.open(clicker, clicker.getName());
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceAdminUI.this.getViewer());
                }
            });
        }
        ConfiguredItem sortItem = switch (this.getPlayerData().getSortFunction()) {
            default -> throw new IncompatibleClassChangeError();
            case SortFunctions.NAME -> ResidenceListUI.CONFIG.ITEMS.SORT_BY_NAME;
            case SortFunctions.SIZE -> ResidenceListUI.CONFIG.ITEMS.SORT_BY_SIZE;
            case SortFunctions.RATINGS -> ResidenceListUI.CONFIG.ITEMS.SORT_BY_RATINGS;
        };
        this.setItem(53, new GUIItem(sortItem.get(this.getViewer(), this.getPlayerData().isSortReversed() ? "\u2b07" : "\u2b06")){

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isRightClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceAdminUI.this.getViewer());
                    ResidenceAdminUI.this.getPlayerData().setSortReversed(!ResidenceAdminUI.this.getPlayerData().isSortReversed());
                    ResidenceAdminUI.open(clicker, ResidenceAdminUI.this.owner);
                } else if (type.isLeftClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceAdminUI.this.getViewer());
                    ResidenceAdminUI.this.getPlayerData().setSortFunction(ResidenceAdminUI.this.getPlayerData().getSortFunction().next());
                    ResidenceAdminUI.open(clicker, ResidenceAdminUI.this.owner);
                }
            }
        });
    }

    @Override
    public void onPageChange(int pageNum) {
        PluginConfig.GUI.CLICK_SOUND.playTo(this.getViewer());
        this.updateTitle(CONFIG.TITLE.parseLine(this.viewer, pageNum, this.getLastPageNumber()));
    }

    public void loadResidences() {
        UserListData data = this.getPlayerData();
        Comparator<ClaimedResidence> comparator = data.getSortFunction().residenceComparator(data.isSortReversed());
        ResidenceListAPI.listResidences().stream().filter(this::checkOwner).sorted(comparator).forEach(residence -> this.addItem(this.generateIcon((ClaimedResidence)residence)));
    }

    protected GUIItem generateIcon(ClaimedResidence residence) {
        Object data = Main.getInstance().getResidenceManager().getResidence(residence);
        PreparedItem icon = PluginConfig.ICON.INFO.prepare(data.getDisplayName(), data.getOwner(), residence.getTrustedPlayers().size() + 1, residence.getMainArea().getSize(), data.countRate(ResidenceRate::recommend), data.countRate(r -> !r.recommend()));
        if (data.canTeleport(this.viewer)) {
            icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.TELEPORTABLE, new Object[0]);
        } else {
            icon.insert("click-lore", CONFIG.ADDITIONAL_LORE.NORMAL, new Object[0]);
        }
        if (!data.getDescription().isEmpty()) {
            icon.insert("description", data.getDescription());
        }
        if (data.getIconMaterial() != null) {
            icon.handleItem((i, p) -> i.setType(data.getIconMaterial()));
            if (data.getCustomModelData() > 0) {
                icon.handleMeta((itemMeta, player) -> itemMeta.setCustomModelData(Integer.valueOf(data.getCustomModelData())));
            }
        }
        return new GUIItem(icon.get(this.viewer), (ResidenceData)data){
            final /* synthetic */ ResidenceData val$data;
            {
                this.val$data = residenceData;
                super(display);
            }

            @Override
            public void onClick(Player clicker, ClickType type) {
                if (type.isLeftClick()) {
                    PluginConfig.GUI.CLICK_SOUND.playTo(ResidenceAdminUI.this.getViewer());
                    ResidenceManageUI.open(ResidenceAdminUI.this.getViewer(), this.val$data, ResidenceAdminUI.this);
                } else if (type.isRightClick()) {
                    if (!this.val$data.canTeleport(ResidenceAdminUI.this.viewer)) {
                        return;
                    }
                    Location target = this.val$data.getTeleportLocation(ResidenceAdminUI.this.viewer);
                    if (target == null) {
                        PluginMessages.TELEPORT.NO_LOCATION.sendTo(clicker, this.val$data.getDisplayName());
                        return;
                    }
                    this.val$data.getResidence().tpToResidence(clicker, clicker, clicker.hasPermission("residence.admin"));
                    PluginMessages.TELEPORT.SOUND.playTo(clicker);
                }
            }
        };
    }

    public static interface CONFIG
    extends Configuration {
        public static final ConfiguredMessage<String> TITLE = ((ConfiguredMessage.Builder)((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a&lResidence list &7(&f%(current_page)&7/%(total_page))")).params("current_page", "total_page")).build();

        public static interface ADDITIONAL_LORE
        extends Configuration {
            public static final ConfiguredMessage<String> NORMAL = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 Click &8|&f View information")).build();
            public static final ConfiguredMessage<String> TELEPORTABLE = ((ConfiguredMessage.Builder)ConfiguredMessage.asString().defaults("&a \u25b6 LClick &8|&f View information", "&a \u25b6 RClick &8|&f Teleport to residence")).build();
        }

        public static interface ITEMS
        extends Configuration {
            public static final ConfiguredItem ALL = ConfiguredItem.create().defaultType(Material.CHEST).defaultName("&a&lAll residences").defaultLore("&7", "&7Now all residences are displayed.", "&7", "&a \u25b6 Click &8|&f See only personal residences").build();
            public static final ConfiguredItem OWNED = ConfiguredItem.create().defaultType(Material.PLAYER_HEAD).defaultName("&7Residence owned by &f%(owner)").defaultLore("&7", "&a \u25b6 Click &8|&f See all residences").params("owner").build();
        }
    }
}

