/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.utils;

import com.artformgames.plugin.residencelist.lib.githubreleases4j.GithubReleases4J;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class GHUpdateChecker {
    @NotNull
    protected static final Pattern GH_URL_PATTERN = Pattern.compile("^https?://github.com/([A-Za-z\\d-_]+)/([^/]*?)/?");
    @NotNull
    protected final Logger logger;
    @NotNull
    protected final String owner;
    @NotNull
    protected final String repo;

    @NotNull
    public static GHUpdateChecker of(@NotNull Logger logger, @NotNull String owner, @NotNull String repo) {
        return new GHUpdateChecker(logger, owner, repo);
    }

    @NotNull
    public static GHUpdateChecker of(@NotNull Plugin plugin) {
        return new GHUpdateChecker(plugin.getLogger(), GHUpdateChecker.getGithubOwner(plugin), plugin.getName());
    }

    @NotNull
    public static Runnable runner(@NotNull Logger logger, @NotNull String owner, @NotNull String repo, @NotNull String currentVersion) {
        return GHUpdateChecker.of(logger, owner, repo).createRunner(currentVersion);
    }

    @NotNull
    public static Runnable runner(@NotNull Plugin plugin) {
        return GHUpdateChecker.of(plugin).createRunner(plugin.getDescription().getVersion());
    }

    @NotNull
    public static BukkitTask run(@NotNull Plugin plugin) {
        return Bukkit.getScheduler().runTaskAsynchronously(plugin, GHUpdateChecker.runner(plugin));
    }

    public GHUpdateChecker(@NotNull Logger logger, @NotNull String owner, @NotNull String repo) {
        this.logger = logger;
        this.owner = owner;
        this.repo = repo;
    }

    public void checkUpdate(@NotNull String currentVersion) {
        Integer behindVersions = GithubReleases4J.getVersionBehind(this.owner, this.repo, currentVersion);
        String downloadURL = GithubReleases4J.getReleasesURL(this.owner, this.repo);
        if (behindVersions == null) {
            this.logger.severe("Failed to check for updates, please check regularly to see if the plugin is updated to avoid security issues.");
            this.logger.severe("Download at -> " + downloadURL);
        } else if (behindVersions == 0) {
            this.logger.info("Now is up-to-date");
        } else if (behindVersions > 0) {
            this.logger.info("New version found! Now is behind " + behindVersions + " version(s).");
            this.logger.info("Download at -> " + downloadURL);
        } else {
            this.logger.severe("Checking for updates failed! The current version is unknown, please use the native version to avoid security issues.");
            this.logger.severe("Download at -> " + downloadURL);
        }
    }

    public Runnable createRunner(@NotNull String currentVersion) {
        return () -> this.checkUpdate(currentVersion);
    }

    protected static String getGithubOwner(Plugin plugin) {
        String websiteOwner = GHUpdateChecker.getGithubOwner(plugin.getDescription().getWebsite());
        if (websiteOwner != null && !websiteOwner.isEmpty()) {
            return websiteOwner;
        }
        List authors = plugin.getDescription().getAuthors();
        if (!authors.isEmpty()) {
            return (String)authors.get(0);
        }
        return plugin.getName();
    }

    protected static String getGithubOwner(String url) {
        Matcher matcher = GH_URL_PATTERN.matcher(url);
        return matcher.find() ? matcher.group(1) : null;
    }
}

