/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.utils;

import com.artformgames.plugin.residencelist.conf.PluginConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GUIUtils {
    private GUIUtils() {
        throw new UnsupportedOperationException();
    }

    public static List<String> sortContent(String content) {
        return GUIUtils.sortContent(content, (Integer)PluginConfig.SETTINGS.LETTERS_PRE_LINE.getNotNull());
    }

    public static List<String> sortContent(String content, int lineLength) {
        ArrayList<String> lore = new ArrayList<String>();
        if (content == null || content.isBlank()) {
            return lore;
        }
        content = content.replaceAll(Pattern.quote("\u00a7"), "&");
        int length = content.length();
        int lines = length / lineLength + (length % lineLength == 0 ? 0 : 1);
        for (int i = 0; i < lines; ++i) {
            int start = i * lineLength;
            int end = Math.min((i + 1) * lineLength, length);
            lore.add(content.substring(start, end));
        }
        return lore;
    }
}

