/*
 * Decompiled with CFR 0.152.
 */
package com.artformgames.plugin.residencelist.utils;

import com.artformgames.plugin.residencelist.conf.PluginConfig;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ResidenceUtils {
    private static final UUID TEMP_UUID = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");

    public static boolean isServerLand(ClaimedResidence residence) {
        return residence.getOwnerUUID() == null || TEMP_UUID.equals(residence.getOwnerUUID()) || Residence.getInstance().getServerUUID().equals(residence.getOwnerUUID());
    }

    public static boolean hiddenDefault() {
        return (Boolean)PluginConfig.SETTINGS.DEFAULT_STATUS.resolve() == false;
    }

    public static boolean viewable(@NotNull ClaimedResidence residence, @NotNull Player viewer) {
        if (ResidenceUtils.isServerLand(residence)) {
            return true;
        }
        if (!residence.getPermissions().has(Flags.hidden, ResidenceUtils.hiddenDefault())) {
            return true;
        }
        return residence.isOwner(viewer);
    }
}

