package fun.wich.client;

import fun.wich.HoneySlimeEntity;
import fun.wich.HoneySlimesMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_609;
import net.minecraft.class_922;
import net.minecraft.class_927;

@Environment(value= EnvType.CLIENT)
public class HoneySlimeEntityRenderer extends class_927<HoneySlimeEntity, class_609<HoneySlimeEntity>> {
	public static final class_2960 TEXTURE = class_2960.method_60655(HoneySlimesMod.MOD_ID, "textures/entity/slime/honey.png");
	public HoneySlimeEntityRenderer(class_5617.class_5618 context) {
		super(context, new class_609<>(context.method_32167(class_5602.field_27654)), 0.25f);
		this.method_4046(new OverlayFeatureRenderer(this, context.method_32170(), TEXTURE));
	}
	@Override protected float getShadowRadius(HoneySlimeEntity state) { return state.method_7152() * 0.25f; }
	@Override
	protected void scale(HoneySlimeEntity slimeEntity, class_4587 matrixStack, float f) {
		matrixStack.method_22905(0.999F, 0.999F, 0.999F);
		matrixStack.method_46416(0.0F, 0.001F, 0.0F);
		float g = (float)slimeEntity.method_7152();
		float i = 1 / ((class_3532.method_16439(f, slimeEntity.field_7387, slimeEntity.field_7388) / (g * 0.5f + 1)) + 1);
		matrixStack.method_22905(i * g, 1 / i * g, i * g);
	}
	@Override public class_2960 getTexture(HoneySlimeEntity state) { return TEXTURE; }
	public static class OverlayFeatureRenderer extends class_3887<HoneySlimeEntity, class_609<HoneySlimeEntity>> {
		protected final class_609<HoneySlimeEntity> model;
		protected final class_2960 texture;
		public OverlayFeatureRenderer(class_3883<HoneySlimeEntity, class_609<HoneySlimeEntity>> context, class_5599 loader, class_2960 texture) {
			super(context);
			this.model = new class_609<>(loader.method_32072(class_5602.field_27655));
			this.texture = texture;
		}
		@Override
		public void render(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, HoneySlimeEntity livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
			class_310 minecraftClient = class_310.method_1551();
			boolean bl = minecraftClient.method_27022(livingEntity) && livingEntity.method_5767();
			if (!livingEntity.method_5767() || bl) {
				this.method_17165().method_17081(this.model);
				this.model.method_2816(livingEntity, limbAngle, limbDistance, tickDelta);
				this.model.method_2819(livingEntity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
				this.model.method_60879(matrixStack, vertexConsumerProvider.getBuffer(bl ? class_1921.method_23287(this.texture) : class_1921.method_23580(this.texture)), i, class_922.method_23622(livingEntity, 0.0F));
			}
		}
	}
}
